/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.rt.tracer;

import io.ghostwriter.Tracer;
import io.ghostwriter.rt.tracer.serializer.StringSerializer;
import io.ghostwriter.rt.tracer.serializer.TracerSerializer;
import io.ghostwriter.rt.tracer.writer.SystemOutWriter;
import io.ghostwriter.rt.tracer.writer.TracerWriter;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;

public class GhostWriterTracer
implements Tracer {
    private final TracerSerializer serializer;
    private final TracerWriter writer;

    public GhostWriterTracer(TracerSerializer serializer, TracerWriter writer) {
        this.serializer = Objects.requireNonNull(serializer);
        this.writer = Objects.requireNonNull(writer);
    }

    public GhostWriterTracer() {
        this(GhostWriterTracer.loadSearializer(), GhostWriterTracer.loadWriter());
    }

    public void entering(Object source, String method, Object ... params) {
        String msg = this.serializer.entering(source, method, params);
        this.writer.writeEntering(source, msg);
    }

    public void exiting(Object source, String method) {
        String msg = this.serializer.exiting(source, method);
        this.writer.writeExiting(source, msg);
    }

    public void valueChange(Object source, String method, String variable, Object value) {
        String msg = this.serializer.valueChange(source, method, variable, value);
        this.writer.writeValueChange(source, msg);
    }

    public <T> void returning(Object source, String method, T returnValue) {
        String msg = this.serializer.returning(source, method, returnValue);
        this.writer.writeReturning(source, msg);
    }

    public void onError(Object source, String method, Throwable error) {
        String msg = this.serializer.onError(source, method, error);
        this.writer.writeError(source, msg);
    }

    public void timeout(Object source, String method, long timeoutThreshold, long timeout) {
        String msg = this.serializer.timeout(source, method, timeoutThreshold, timeout);
        this.writer.writeTimeout(source, msg);
    }

    private static TracerSerializer loadSearializer() {
        ServiceLoader<TracerSerializer> serviceLoader = ServiceLoader.load(TracerSerializer.class);
        TracerSerializer loadedSerializer = null;
        Iterator<TracerSerializer> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            TracerSerializer serializer;
            loadedSerializer = serializer = iterator.next();
        }
        if (loadedSerializer == null) {
            loadedSerializer = new StringSerializer();
        }
        return loadedSerializer;
    }

    private static TracerWriter loadWriter() {
        ServiceLoader<TracerWriter> serviceLoader = ServiceLoader.load(TracerWriter.class);
        TracerWriter loadedWriter = null;
        Iterator<TracerWriter> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            TracerWriter writer;
            loadedWriter = writer = iterator.next();
        }
        if (loadedWriter == null) {
            loadedWriter = new SystemOutWriter();
        }
        return loadedWriter;
    }
}

