/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.rt.tracer;

final class Indentation {
    private final ThreadLocal<Integer> indentationLevel = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private final String indentationString;

    public Indentation() {
        this(" ");
    }

    public Indentation(String indentationString) {
        this.indentationString = indentationString;
    }

    public void indent() {
        int currentLevel = this.indentationLevel.get();
        this.indentationLevel.set(currentLevel + 1);
    }

    public void dedent() {
        int currentLevel = this.indentationLevel.get();
        int newLevel = currentLevel == 0 ? currentLevel : currentLevel - 1;
        this.indentationLevel.set(newLevel);
    }

    public StringBuffer apply(StringBuffer stringBuffer) {
        int level = this.indentationLevel.get();
        for (int i = 0; i < level; ++i) {
            stringBuffer.append(this.indentationString);
        }
        return stringBuffer;
    }
}

