/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.rt.tracer;

import io.ghostwriter.Tracer;
import io.ghostwriter.rt.tracer.Indentation;
import io.ghostwriter.rt.tracer.serializer.StringSerializer;
import io.ghostwriter.rt.tracer.serializer.TracerSerializer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GhostWriterTracer
implements Tracer {
    private static Logger LOG = LoggerFactory.getLogger(GhostWriterTracer.class);
    private final TracerSerializer serializer;
    private final Indentation indentation;

    public GhostWriterTracer(TracerSerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer);
        this.indentation = new Indentation();
    }

    public GhostWriterTracer() {
        this(new StringSerializer());
    }

    public void entering(Object source, String method, Object ... params) {
        int DEFAULT_CAPACITY = 255;
        StringBuffer sb = new StringBuffer(255);
        String context = this.serializer.serialize(source);
        this.indentation.apply(sb).append(context).append(".").append(method).append("(");
        this.appendParameters(sb, params).append(") {");
        this.write(sb);
        this.indentation.indent();
    }

    public void exiting(Object source, String method, Object returnValue) {
        int DEFAULT_CAPACITY = 64;
        StringBuffer sb = new StringBuffer(64);
        this.indentation.dedent();
        String value = this.serializer.serialize(returnValue);
        this.indentation.apply(sb).append("} = ").append(value);
        this.write(sb);
    }

    public void exiting(Object source, String method) {
        int DEFAULT_CAPACITY = 64;
        StringBuffer sb = new StringBuffer(64);
        this.indentation.dedent();
        this.indentation.apply(sb).append("}");
        this.write(sb);
    }

    public void valueChange(Object source, String method, String variable, Object value) {
        int DEFAULT_CAPACITY = 64;
        StringBuffer sb = new StringBuffer(64);
        String strValue = this.serializer.serialize(value);
        this.indentation.apply(sb).append(variable).append(" = ").append(strValue);
        this.write(sb);
    }

    public void onError(Object source, String method, Throwable error) {
        int DEFAULT_CAPACITY = 128;
        StringBuffer sb = new StringBuffer(128);
        String errorStr = this.serializer.serialize(error);
        this.indentation.apply(sb).append("<Exception> = ").append(errorStr);
        this.write(sb);
    }

    private StringBuffer appendParameters(StringBuffer sb, Object[] params) {
        int NUMBER_OF_ENTRIES_PER_PARAMETERS = 2;
        for (int i = 0; i < params.length; i += 2) {
            boolean isFinalParameter;
            Object parameterName = params[i];
            Object parameterValue = params[i + 1];
            String name = this.serializer.serialize(parameterName);
            String value = this.serializer.serialize(parameterValue);
            sb.append(name).append(" = ").append(value);
            boolean bl = isFinalParameter = i == params.length - 2;
            if (isFinalParameter) continue;
            sb.append(", ");
        }
        return sb;
    }

    private void write(StringBuffer sb) {
        LOG.trace(sb.toString());
    }
}

