package io.ghostwriter.rt.tracer.serializer;


import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.lang.reflect.Method;

public class StringSerializer implements TracerSerializer {

    private String valueToString(Object value) {
        String stringValue = String.valueOf(value);
        if (!isToStringProvided(value)) {
            stringValue = ReflectionToStringBuilder.toString(value);
        }

        return stringValue;
    }

    private boolean isToStringProvided(Object value) {
        if (value == null) {
            return true; // String.valueOf will handle null properly
        }

        try {
            final Class<?> aClass = value.getClass();
            final Method toString = aClass.getMethod("toString");
            final Class<?> declaringClass = toString.getDeclaringClass();

            return  declaringClass != Object.class;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String serialize(Object value) {
        return valueToString(value);
    }

}
