/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.rt.tracer.writer;

import io.ghostwriter.rt.tracer.serializer.SerializerLoader;
import io.ghostwriter.rt.tracer.serializer.StringSerializer;
import io.ghostwriter.rt.tracer.serializer.TracerSerializer;
import io.ghostwriter.rt.tracer.writer.TracerWriter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JWriter
implements TracerWriter {
    private final TracerSerializer serializer;

    public Slf4JWriter() {
        TracerSerializer loaded = SerializerLoader.load();
        boolean defaultSerializerLoaded = loaded instanceof StringSerializer;
        this.serializer = defaultSerializerLoaded ? new StringSerializer(true, false) : loaded;
    }

    public Slf4JWriter(TracerSerializer serializer) {
        this.serializer = serializer;
    }

    public void writeEntering(Object source, String method, Object ... params) {
        Logger logger = Slf4JWriter.loggerForEventSource(source);
        if (logger.isTraceEnabled()) {
            logger.trace(this.serializer.entering(source, method, params));
        }
    }

    public void writeReturning(Object source, String method, Object returnValue) {
        Logger logger = Slf4JWriter.loggerForEventSource(source);
        if (logger.isTraceEnabled()) {
            logger.trace(this.serializer.returning(source, method, returnValue));
        }
    }

    public void writeExiting(Object source, String method) {
        Logger logger = Slf4JWriter.loggerForEventSource(source);
        if (logger.isTraceEnabled()) {
            logger.trace(this.serializer.exiting(source, method));
        }
    }

    public void writeValueChange(Object source, String method, String variable, Object value) {
        Logger logger = Slf4JWriter.loggerForEventSource(source);
        if (logger.isTraceEnabled()) {
            logger.trace(this.serializer.valueChange(source, method, variable, value));
        }
    }

    public void writeError(Object source, String method, Throwable error) {
        Logger logger = Slf4JWriter.loggerForEventSource(source);
        if (logger.isTraceEnabled()) {
            logger.trace(this.serializer.onError(source, method, error));
        }
    }

    private static Logger loggerForEventSource(Object source) {
        Objects.requireNonNull(source);
        Class<?> clazz = source instanceof Class ? (Class<?>)source : source.getClass();
        return LoggerFactory.getLogger(clazz);
    }
}

