/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.rt.snaperr.serializer;

import io.ghostwriter.rt.snaperr.serializer.TriggerSerializer;
import io.ghostwriter.rt.snaperr.trigger.Trigger;
import io.ghostwriter.rt.snaperr.trigger.WatchedValue;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class StringSerializer
implements TriggerSerializer<String> {
    @Override
    public String serializeTrigger(Trigger trigger) {
        Objects.requireNonNull(trigger);
        Object context = trigger.getContext();
        String methodName = trigger.getMethodName();
        String contextCanonicalName = context.getClass().getCanonicalName();
        if (context instanceof Class) {
            Class klazz = (Class)context;
            contextCanonicalName = klazz.getCanonicalName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(contextCanonicalName).append(".").append(methodName).append(" {\n");
        Map<String, WatchedValue> watched = trigger.getWatched();
        this.appendWatchedValues(sb, watched);
        sb.append("}");
        return sb.toString();
    }

    private void appendWatchedValues(StringBuilder sb, Map<String, WatchedValue> watched) {
        for (WatchedValue watchedValue : watched.values()) {
            String name = watchedValue.getName();
            Object value = watchedValue.getValue();
            String strValue = this.valueToString(value);
            sb.append("\t").append(name).append("=").append(strValue).append("\n");
        }
    }

    private String valueToString(Object value) {
        String stringValue = String.valueOf(value);
        if (!this.isToStringProvided(value)) {
            stringValue = ReflectionToStringBuilder.toString((Object)value);
        }
        return stringValue;
    }

    private boolean isToStringProvided(Object value) {
        if (value == null) {
            return true;
        }
        try {
            Class<?> aClass = value.getClass();
            Method toString = aClass.getMethod("toString", new Class[0]);
            Class<?> declaringClass = toString.getDeclaringClass();
            return declaringClass != Object.class;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

