/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.rt.snaperr.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.ghostwriter.rt.snaperr.serializer.TriggerSerializer;
import io.ghostwriter.rt.snaperr.trigger.Trigger;
import io.ghostwriter.rt.snaperr.trigger.WatchedValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class JsonSerializer
implements TriggerSerializer<String> {
    private final Gson gson;
    private final Integer stackTraceLimit;

    public JsonSerializer() {
        this(true, null);
    }

    public JsonSerializer(boolean doPrettyPrint, Integer stackTraceLimit) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.enableComplexMapKeySerialization();
        if (doPrettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        this.gson = gsonBuilder.create();
        if (stackTraceLimit < 0) {
            throw new IllegalArgumentException("Stack trace limit must be a positive number! Got: " + stackTraceLimit);
        }
        this.stackTraceLimit = stackTraceLimit;
    }

    @Override
    public String serializeTrigger(Trigger trigger) {
        Objects.requireNonNull(trigger);
        Object context = trigger.getContext();
        if (context instanceof Class) {
            Class klazz = (Class)context;
            context = klazz.getCanonicalName();
        }
        String methodName = trigger.getMethodName();
        Throwable throwable = trigger.getThrowable();
        Map<String, Object> state = this.getState(trigger.getWatched());
        Representation representation = new Representation(context, methodName, throwable, state);
        String json = this.gson.toJson((Object)representation);
        return json;
    }

    private Map<String, Object> getState(Map<String, WatchedValue> watched) {
        HashMap<String, Object> state = new HashMap<String, Object>(watched.size());
        for (Map.Entry<String, WatchedValue> element : watched.entrySet()) {
            String variableName = element.getKey();
            Object elementValue = element.getValue().getValue();
            state.put(variableName, elementValue);
        }
        return state;
    }

    private class Representation {
        private final Object context;
        private final String methodName;
        private final Map<String, Object> stateSnapshot;
        private final String cause;
        private final StackTraceElement[] stackTrace;

        public Representation(Object context, String methodName, Throwable throwable, Map<String, Object> state) {
            this.context = context;
            this.methodName = methodName;
            this.stateSnapshot = state;
            this.cause = String.valueOf(throwable);
            this.stackTrace = this.limitedStackTrace(throwable);
        }

        private StackTraceElement[] limitedStackTrace(Throwable throwable) {
            boolean stackTraceLimitDisabled = JsonSerializer.this.stackTraceLimit == null || JsonSerializer.this.stackTraceLimit == 0;
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            if (stackTraceLimitDisabled) {
                return stackTrace;
            }
            return Arrays.copyOfRange(stackTrace, 0, (int)JsonSerializer.this.stackTraceLimit);
        }
    }
}

