/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.rt.snaperr;

import io.ghostwriter.Tracer;
import io.ghostwriter.rt.snaperr.handler.Slf4jWriter;
import io.ghostwriter.rt.snaperr.trigger.Trigger;
import io.ghostwriter.rt.snaperr.trigger.TriggerHandler;
import io.ghostwriter.rt.snaperr.trigger.WatchedValue;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class GhostWriterSnaperr
implements Tracer {
    private ThreadLocal<Map<String, WatchedValue>> watchedThreadState = new ThreadLocal<Map<String, WatchedValue>>(){

        @Override
        protected Map<String, WatchedValue> initialValue() {
            return new TreeMap<String, WatchedValue>();
        }
    };
    private ThreadLocal<Trigger> processedTrigger = new ThreadLocal<Trigger>(){

        @Override
        protected Trigger initialValue() {
            return null;
        }
    };
    private TriggerHandler triggerHandler;

    private static TriggerHandler defaultTriggerHandler() {
        return new Slf4jWriter();
    }

    public GhostWriterSnaperr() {
        this(GhostWriterSnaperr.defaultTriggerHandler());
    }

    public GhostWriterSnaperr(TriggerHandler triggerHandler) {
        this.triggerHandler = Objects.requireNonNull(triggerHandler);
    }

    public void entering(Object source, String method, Object ... params) {
        Map<String, WatchedValue> watched = this.watchedThreadState.get();
        watched.clear();
        this.clearErrorState();
        for (int i = 0; i < params.length - 1; ++i) {
            Object paramName = params[i++];
            Object paramValue = params[i];
            String name = (String)paramName;
            this.watch(name, paramValue);
        }
    }

    public void exiting(Object source, String method, Object returnValue) {
        Map<String, WatchedValue> watched = this.watchedThreadState.get();
        watched.clear();
    }

    public void exiting(Object source, String method) {
        Map<String, WatchedValue> watched = this.watchedThreadState.get();
        watched.clear();
    }

    public void valueChange(Object source, String method, String variable, Object value) {
        this.watch(variable, value);
    }

    public void onError(Object source, String method, Throwable error) {
        if (this.isPropagatedError()) {
            return;
        }
        Trigger trigger = new Trigger(source, method, this.watchedThreadState.get(), error);
        this.setErrorState(trigger);
        if (this.triggerHandler != null) {
            this.triggerHandler.onError(trigger);
        }
    }

    private void watch(String variableName, Object variableReference) {
        Map<String, WatchedValue> watched = this.watchedThreadState.get();
        WatchedValue watchedValue = new WatchedValue(variableName, variableReference);
        watched.put(variableName, watchedValue);
    }

    private void clearErrorState() {
        this.processedTrigger.set(null);
    }

    private void setErrorState(Trigger trigger) {
        this.processedTrigger.set(trigger);
    }

    private boolean isPropagatedError() {
        return this.processedTrigger.get() != null;
    }
}

