package io.ghostwriter.rt.snaperr.trigger;

import java.lang.ref.WeakReference;

public final class WatchedValue {

    final private String name;

    final private WeakReference<Object> value;

    public WatchedValue(String name, Object value) {
        this.name = name;
        this.value = new WeakReference<>(value);
    }

    public String getName() {
        return name;
    }

    // TODO(snorbi07): can we screw up goal of using WeakReferences by returning the value directly?
    // Check/verify that this is isn't dependent on how getValue is used
    public Object getValue() {
        return value.get();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        WatchedValue that = (WatchedValue) o;

        if (name != null ? !name.equals(that.name) : that.name != null) return false;
        return !(value != null ? !value.equals(that.value) : that.value != null);

    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (value != null ? value.hashCode() : 0);
        return result;
    }
}
