package io.ghostwriter.rt.snaperr.trigger;

import java.util.Collections;
import java.util.Map;


final public class Trigger {

    final String methodName;

    final Object context;

    final Map<String, WatchedValue> watched;

    final Throwable throwable;

    public Trigger(Object context, String methodName, Map<String, WatchedValue> watched, Throwable throwable) {
        this.context = context;
        this.methodName = methodName;
        this.watched = Collections.unmodifiableMap(watched);
        this.throwable = throwable;
    }

    public String getMethodName() {
        return methodName;
    }

    public Object getContext() {
        return context;
    }

    public Map<String, WatchedValue> getWatched() {
        return watched;
    }

    public Throwable getThrowable() {
        return throwable;
    }
}
