package io.ghostwriter.rt.snaperr.serializer;


import io.ghostwriter.rt.snaperr.trigger.Trigger;
import io.ghostwriter.rt.snaperr.trigger.WatchedValue;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;

public class StringSerializer implements TriggerSerializer<String> {

    @Override
    public String serializeTrigger(Trigger trigger) {
        Objects.requireNonNull(trigger);
        final Object context = trigger.getContext();
        final String methodName = trigger.getMethodName();

        String contextCanonicalName = context.getClass().getCanonicalName();
        if (context instanceof Class<?>) {
            Class<?> klazz = (Class<?>) context;
            contextCanonicalName = klazz.getCanonicalName();
        }

        StringBuilder sb = new StringBuilder();
        sb.append(contextCanonicalName).append(".").append(methodName).append(" {\n");

        final Map<String, WatchedValue> watched = trigger.getWatched();
        appendWatchedValues(sb, watched);

        sb.append("}");

        return sb.toString();
    }

    private void appendWatchedValues(StringBuilder sb, Map<String, WatchedValue> watched) {
        for (WatchedValue watchedValue : watched.values()) {
            final String name = watchedValue.getName();
            final Object value = watchedValue.getValue();

            String strValue = valueToString(value);
            sb.append("\t").append(name).append("=").append(strValue).append("\n");
        }
    }

    private String valueToString(Object value) {
        String stringValue = String.valueOf(value);
        if (!isToStringProvided(value)) {
            stringValue = ReflectionToStringBuilder.toString(value);
        }

        return stringValue;
    }

    private boolean isToStringProvided(Object value) {
        if (value == null) {
            return true; // String.valueOf will handle null properly
        }

        try {
            final Class<?> aClass = value.getClass();
            final Method toString = aClass.getMethod("toString");
            final Class<?> declaringClass = toString.getDeclaringClass();

            return  declaringClass != Object.class;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

}
