package io.ghostwriter.rt.snaperr.handler;

import io.ghostwriter.rt.snaperr.GhostWriterSnaperr;
import io.ghostwriter.rt.snaperr.serializer.StringSerializer;
import io.ghostwriter.rt.snaperr.serializer.TriggerSerializer;
import io.ghostwriter.rt.snaperr.trigger.Trigger;
import io.ghostwriter.rt.snaperr.trigger.TriggerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jWriter implements TriggerHandler {

    private static Logger LOG = LoggerFactory.getLogger(Slf4jWriter.class);

    private TriggerSerializer<String> serializer = new StringSerializer();

    @Override
    public void onError(Trigger trigger) {
        StringBuilder sb = new StringBuilder();
        sb.append(GhostWriterSnaperr.class.getCanonicalName()).append(" state snapshot: \n");
        final String str = serializer.serializeTrigger(trigger);
        sb.append(str);

        LOG.error(sb.toString());
    }

}
