/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.model;

import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.model.AstModel;
import io.ghostwriter.openjdk.v7.model.Clazz;
import io.ghostwriter.openjdk.v7.model.Parameter;
import java.util.List;
import java.util.Objects;

public class Method
extends AstModel<JCTree.JCMethodDecl> {
    private final String name;
    private final Clazz clazz;
    private final List<Parameter> parameters;

    public Method(String name, Clazz clazz, List<Parameter> parameters, JCTree.JCMethodDecl representation) {
        super(representation);
        Objects.requireNonNull(clazz, "Must provide a valid class AST model!");
        Objects.requireNonNull(name, "Must provide a valid parameter name!");
        if ("".equals(name)) {
            throw new IllegalArgumentException("Must provide a non-empty method name!");
        }
        this.name = name;
        this.clazz = clazz;
        this.parameters = parameters;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean isConstructor() {
        String CONSTRUCTOR_IDENTIFIER = "<init>";
        return "<init>".equals(this.name);
    }

    public boolean doesHaveResult() {
        JCTree.JCExpression type = ((JCTree.JCMethodDecl)this.representation()).restype;
        boolean result = false;
        if (type != null) {
            String typeName = type.toString();
            result = !"void".equals(typeName) && !"java.lang.Void".equals(typeName);
        }
        return result;
    }

    public String toString() {
        return "Method [class=" + this.clazz.getFullyQualifiedClassName() + ", name=" + this.name + ", parameters=" + this.parameters + "]";
    }
}

