/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.common;

import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;

public enum Logger {

    private static Messager messager;

    private static String format(Class<?> klass, String method, String message) {
        int INITIAL_CAPACITY = 32;
        StringBuilder sb = new StringBuilder(32);
        if (klass != null) {
            sb.append(klass.getName());
            sb.append(".");
        }
        sb.append(method);
        sb.append(": ");
        sb.append(message);
        return sb.toString();
    }

    public static void note(Class<?> type, String method, String message) {
        Logger.validateState();
        String output = Logger.format(type, method, message);
        messager.printMessage(Diagnostic.Kind.NOTE, output);
    }

    public static void warning(Class<?> type, String method, String message) {
        Logger.validateState();
        String output = Logger.format(type, method, message);
        messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, output);
    }

    public static void error(Class<?> type, String method, String message) {
        Logger.validateState();
        String output = Logger.format(type, method, message);
        messager.printMessage(Diagnostic.Kind.ERROR, output);
    }

    public static void initialize(Messager msg) {
        if (msg == null) {
            throw new NullPointerException("Cannot initialize with null!");
        }
        messager = msg;
    }

    private static void validateState() {
        if (messager == null) {
            throw new IllegalStateException("Logger has not been initialized!");
        }
    }
}

