/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.collector.BlockBasedMutatedVariableCollector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Objects;

public class ReturnExpressionMutationExtractionTranslator
extends TreeTranslator
implements Translator<Method> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;
    private Method model;

    public ReturnExpressionMutationExtractionTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = javac;
        this.helper = helper;
    }

    @Override
    public void translate(Method model) {
        this.model = Objects.requireNonNull(model);
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        representation.accept(this);
    }

    @Override
    public void visitBlock(JCTree.JCBlock block) {
        ListBuffer<JCTree.JCStatement> newBody = new ListBuffer<JCTree.JCStatement>();
        java.util.List statements = block.getStatements();
        for (JCTree.JCStatement statement : statements) {
            this.processStatement(statement, newBody);
        }
        block.stats = newBody.toList();
        super.visitBlock(block);
    }

    private void processStatement(JCTree.JCStatement statement, ListBuffer<JCTree.JCStatement> newBody) {
        boolean isReturnStatement = statement instanceof JCTree.JCReturn;
        if (!isReturnStatement) {
            newBody.add(statement);
            return;
        }
        assert (isReturnStatement);
        JCTree.JCReturn returnStatement = (JCTree.JCReturn)statement;
        this.processReturnStatement(returnStatement, newBody);
    }

    private void processReturnStatement(JCTree.JCReturn returnStatement, ListBuffer<JCTree.JCStatement> newBody) {
        if (this.doesContainMutations(returnStatement)) {
            JCTree.JCExpression expression = returnStatement.getExpression();
            JCTree.JCVariableDecl mutationResult = this.mutationCaptureVariable(expression);
            returnStatement.expr = this.javac.expression(this.mutationCaptureVariableName());
            newBody.add(mutationResult);
        }
        newBody.add(returnStatement);
    }

    private boolean doesContainMutations(JCTree.JCReturn returnStatement) {
        java.util.List valueChangeExpressions = new BlockBasedMutatedVariableCollector(returnStatement, this.javac, this.helper).toList();
        return !valueChangeExpressions.isEmpty();
    }

    protected JCTree.JCVariableDecl mutationCaptureVariable(JCTree.JCExpression value) {
        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)this.model.representation();
        if (!this.model.doesHaveResult()) {
            throw new IllegalArgumentException("Method does not have a return type: " + this.model.doesHaveResult());
        }
        String name = this.mutationCaptureVariableName();
        JCTree.JCExpression returnType = this.javac.methodReturnType(method);
        JCTree.JCVariableDecl variable = this.javac.variable(returnType, name, value);
        JCTree.JCAnnotation excludeAnnotation = this.javac.annotation("io.ghostwriter.annotation.Exclude");
        variable.mods.annotations = List.of(excludeAnnotation);
        return variable;
    }

    private String mutationCaptureVariableName() {
        return "$capturedReturnExpression_";
    }
}

