/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.common.RuntimeHandler;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Iterator;
import java.util.Objects;

public class OnErrorTranslator
implements Translator<Method> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper compilerHelper;

    public OnErrorTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = Objects.requireNonNull(javac);
        this.compilerHelper = Objects.requireNonNull(helper);
    }

    @Override
    public void translate(Method model) {
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        ListBuffer<JCTree.JCStatement> instrumentedBody = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCVariableDecl exceptionHolder = this.exceptionVariable(model);
        instrumentedBody.add(exceptionHolder);
        this.instrumentExceptionCapture(model, instrumentedBody);
        representation.body.stats = instrumentedBody.toList();
    }

    private void instrumentExceptionCapture(Method model, ListBuffer<JCTree.JCStatement> instrumentedBody) {
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        Iterator<JCTree.JCStatement> topLevelStatements = representation.body.stats.iterator();
        boolean foundEnteringExitingTryFinallyBlock = false;
        while (topLevelStatements.hasNext()) {
            JCTree.JCStatement statement = topLevelStatements.next();
            if (statement instanceof JCTree.JCTry) {
                foundEnteringExitingTryFinallyBlock = true;
                JCTree.JCTry tryFinally = (JCTree.JCTry)statement;
                JCTree.JCTry tryCatchFinally = this.extendWithErrorCapture(model, tryFinally);
                instrumentedBody.add(tryCatchFinally);
                continue;
            }
            instrumentedBody.add(statement);
        }
        if (!foundEnteringExitingTryFinallyBlock) {
            throw new IllegalArgumentException("Method does not have the expected structure:  " + representation.toString());
        }
    }

    protected JCTree.JCTry extendWithErrorCapture(Method model, JCTree.JCTry tryFinally) {
        JCTree.JCStatement conditionalOnErrorExpression = this.conditionalOnErrorExpression(model);
        JCTree.JCBlock exitingBlock = tryFinally.getFinallyBlock();
        List<JCTree.JCStatement> onErrorAndExitingStatements = exitingBlock.stats.prepend(conditionalOnErrorExpression);
        JCTree.JCBlock onErrorAndExitingBlock = this.javac.block(onErrorAndExitingStatements);
        JCTree.JCBlock methodBodyBlock = tryFinally.body;
        JCTree.JCCatch captureException = this.captureException(model);
        return this.javac.tryCatchFinally(methodBodyBlock, captureException, onErrorAndExitingBlock);
    }

    protected String getExecutionStatusHandler() {
        return RuntimeHandler.ON_ERROR.toString();
    }

    protected String getFullyQualifiedTypeOfError() {
        return "java.lang.Throwable";
    }

    private JCTree.JCStatement conditionalOnErrorExpression(Method model) {
        JCTree.JCStatement onErrorExpression = this.onErrorExpression(model);
        String exceptionVariableName = this.exceptionVariableName(model);
        JCTree.JCIdent exceptionVariableIdentifier = this.javac.identifier(exceptionVariableName);
        JCTree.JCExpression exceptionIsNotNullCondition = this.javac.notEqualExpression(this.javac.nullLiteral(), exceptionVariableIdentifier);
        return this.javac.ifCondition(exceptionIsNotNullCondition, onErrorExpression);
    }

    protected JCTree.JCCatch captureException(Method model) {
        String fullyQualifiedTypeOfError = this.getFullyQualifiedTypeOfError();
        JCTree.JCExpression type = this.javac.expression(fullyQualifiedTypeOfError);
        String caughtExceptionParameterName = this.catchBlockParameterName();
        String exceptionVariableName = this.exceptionVariableName(model);
        JCTree.JCIdent exceptionVariable = this.javac.identifier(exceptionVariableName);
        JCTree.JCIdent capturedExceptionIdentifier = this.javac.identifier(caughtExceptionParameterName);
        JCTree.JCAssign captureCaughtException = this.javac.assign(exceptionVariable, capturedExceptionIdentifier);
        JCTree.JCExpressionStatement executeCaptureAssignment = this.javac.execute(captureCaughtException);
        JCTree.JCThrow throwStatement = this.javac.throwStatement(capturedExceptionIdentifier);
        JCTree.JCBlock catchBlock = this.javac.block(List.of(executeCaptureAssignment, throwStatement));
        JCTree.JCVariableDecl exceptionParam = this.javac.variable(type, caughtExceptionParameterName, null);
        return this.javac.catchExpression(exceptionParam, catchBlock);
    }

    protected String catchBlockParameterName() {
        return "$e_";
    }

    protected JCTree.JCVariableDecl exceptionVariable(Method model) {
        String fullyQualifiedTypeOfError = this.getFullyQualifiedTypeOfError();
        JCTree.JCExpression type = this.javac.expression(fullyQualifiedTypeOfError);
        JCTree.JCExpression value = this.javac.nullLiteral();
        String name = this.exceptionVariableName(model);
        return this.javac.variable(type, name, value);
    }

    private String exceptionVariableName(Method model) {
        return "$throwable_";
    }

    protected JCTree.JCStatement onErrorExpression(Method model) {
        String onErrorHandler = this.getExecutionStatusHandler();
        if (onErrorHandler == null || "".equals(onErrorHandler)) {
            Logger.error(this.getClass(), "onErrorExpression", "invalid fully qualified name for 'onError' handler: " + String.valueOf(onErrorHandler));
        }
        JCTree.JCExpression exitingHandlerExpression = this.javac.expression(onErrorHandler);
        ListBuffer handlerArguments = ListBuffer.lb();
        JCTree.JCExpression thisOrClass = this.compilerHelper.methodContext(model);
        handlerArguments.add(thisOrClass);
        JCTree.JCLiteral methodName = this.compilerHelper.methodName(model);
        handlerArguments.add(methodName);
        String exceptionVariableName = this.exceptionVariableName(model);
        JCTree.JCIdent exceptionVariableIdentifier = this.javac.identifier(exceptionVariableName);
        handlerArguments.add(exceptionVariableIdentifier);
        return this.javac.call(exitingHandlerExpression, handlerArguments.toList());
    }
}

