/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.ConstructorTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.EnteringExitingTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.OnErrorTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.ReturnExpressionMutationExtractionTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.ast.translator.ValueChangeTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.WrapInBlockTranslator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Objects;

public class MethodTranslator
implements Translator<Method> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;

    public MethodTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = Objects.requireNonNull(javac, "Must provide a valid instance of " + JavaCompiler.class.getSimpleName());
        this.helper = Objects.requireNonNull(helper, "Must provide a valid instance of " + JavaCompilerHelper.class.getSimpleName());
    }

    protected boolean doTraceValueChanges() {
        return true;
    }

    protected boolean doTraceErrors() {
        return true;
    }

    @Override
    public void translate(Method model) {
        boolean isDefined;
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        boolean isExcluded = this.isMethodExcluded(model);
        if (isExcluded) {
            Logger.note(this.getClass(), "translate", "skipping instrumentation of method: " + model.getName());
            return;
        }
        boolean bl = isDefined = representation.body != null;
        if (!isDefined) {
            return;
        }
        if (this.doTraceValueChanges()) {
            this.traceValueChanges(model);
        }
        this.traceEnteringExiting(model);
        if (this.doTraceErrors()) {
            this.traceErrors(model);
        }
        if (model.isConstructor()) {
            this.extractConstructorCallsToFirstStatement(model);
        }
        String fullyQualifiedClassName = model.getClazz().getFullyQualifiedClassName();
        Logger.note(this.getClass(), "translate", "(" + fullyQualifiedClassName + ")" + representation.toString());
    }

    private boolean isMethodExcluded(Method model) {
        JCTree.JCMethodDecl methodRepresentation = (JCTree.JCMethodDecl)model.representation();
        boolean isMethodExcluded = this.helper.isExcluded(methodRepresentation);
        JCTree.JCClassDecl classRepresentation = (JCTree.JCClassDecl)model.getClazz().representation();
        boolean isClassExcluded = this.helper.isExcluded(classRepresentation);
        return isClassExcluded || isMethodExcluded;
    }

    private void extractConstructorCallsToFirstStatement(Method model) {
        ConstructorTranslator constructorTranslator = new ConstructorTranslator(this.helper);
        constructorTranslator.translate(model);
    }

    private void traceEnteringExiting(Method model) {
        EnteringExitingTranslator enteringExitingTranslator = new EnteringExitingTranslator(this.javac, this.helper);
        enteringExitingTranslator.translate(model);
    }

    private void traceErrors(Method model) {
        OnErrorTranslator onErrorTranslator = new OnErrorTranslator(this.javac, this.helper);
        onErrorTranslator.translate(model);
    }

    protected void traceValueChanges(Method model) {
        WrapInBlockTranslator wrapInBlockTranslator = new WrapInBlockTranslator(this.javac);
        wrapInBlockTranslator.translate(model);
        ReturnExpressionMutationExtractionTranslator returnExpressionTranslator = new ReturnExpressionMutationExtractionTranslator(this.javac, this.helper);
        returnExpressionTranslator.translate(model);
        ValueChangeTranslator valueChangeTranslator = new ValueChangeTranslator(this.javac, this.helper);
        valueChangeTranslator.translate(model);
    }
}

