/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.collector.ReturnStatementCollector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.common.RuntimeHandler;
import io.ghostwriter.openjdk.v7.model.Method;
import io.ghostwriter.openjdk.v7.model.Parameter;
import java.util.ArrayList;
import java.util.Objects;

public class EnteringExitingTranslator
implements Translator<Method> {
    private static final String ARGUMENTS_ARRAY_TYPE = "java.lang.Object";
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;

    public EnteringExitingTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = Objects.requireNonNull(javac);
        this.helper = Objects.requireNonNull(helper);
    }

    @Override
    public void translate(Method model) {
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        ListBuffer instrumentedBody = ListBuffer.lb();
        if (model.doesHaveResult()) {
            JCTree.JCVariableDecl resultVariable = this.resultVariable(model);
            instrumentedBody.add(resultVariable);
            this.captureReturnStatements(model);
        }
        JCTree.JCExpressionStatement enteringExpression = this.enteringExpression(model);
        instrumentedBody.add(enteringExpression);
        JCTree.JCBlock methodBodyBlock = this.javac.block(representation.body.stats);
        JCTree.JCExpressionStatement exitingExpression = this.exitingExpression(model);
        JCTree.JCBlock exitingBlock = this.javac.block(List.of(exitingExpression));
        JCTree.JCTry tryBlock = this.javac.tryFinally(methodBodyBlock, exitingBlock);
        instrumentedBody.add(tryBlock);
        representation.body.stats = instrumentedBody.toList();
    }

    protected String getArgumentsArrayType() {
        return ARGUMENTS_ARRAY_TYPE;
    }

    protected String getEnteringHandler() {
        return RuntimeHandler.ENTERING.toString();
    }

    protected String getExitingHandler() {
        return RuntimeHandler.EXITING.toString();
    }

    protected void captureReturnStatements(Method model) {
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        ReturnStatementCollector returnStatements = new ReturnStatementCollector(representation);
        for (JCTree.JCReturn returnStatement : returnStatements) {
            this.captureReturnStatement(returnStatement, model);
        }
    }

    protected void captureReturnStatement(JCTree.JCReturn returnStatement, Method model) {
        String resultName = this.methodResultVariableName(model);
        JCTree.JCIdent resultIdentifier = this.javac.identifier(resultName);
        JCTree.JCExpression originalReturnExpression = returnStatement.expr;
        returnStatement.expr = this.javac.assign(resultIdentifier, originalReturnExpression);
    }

    protected JCTree.JCVariableDecl resultVariable(Method model) {
        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)model.representation();
        if (!model.doesHaveResult()) {
            throw new IllegalArgumentException("Method does not have a return type: " + model.doesHaveResult());
        }
        String name = this.methodResultVariableName(model);
        JCTree.JCExpression returnType = this.javac.methodReturnType(method);
        JCTree.JCExpression value = this.javac.defaultValueForType(returnType);
        return this.javac.variable(returnType, name, value);
    }

    protected JCTree.JCExpressionStatement enteringExpression(Method model) {
        String enteringHandler = this.getEnteringHandler();
        if (enteringHandler == null || "".equals(enteringHandler)) {
            Logger.error(this.getClass(), "enteringExpression", "invalid fully qualified name for 'entering' handler: " + String.valueOf(enteringHandler));
        }
        JCTree.JCExpression enteringHandlerExpression = this.javac.expression(enteringHandler);
        ListBuffer handlerArguments = ListBuffer.lb();
        JCTree.JCExpression thisOrClass = this.helper.methodContext(model);
        handlerArguments.add(thisOrClass);
        JCTree.JCLiteral methodName = this.helper.methodName(model);
        handlerArguments.add(methodName);
        JCTree.JCExpression methodArguments = this.methodArguments(model);
        handlerArguments.add(methodArguments);
        return this.javac.call(enteringHandlerExpression, handlerArguments.toList());
    }

    protected JCTree.JCExpressionStatement exitingExpression(Method model) {
        String exitingHandler = this.getExitingHandler();
        if (exitingHandler == null || "".equals(exitingHandler)) {
            Logger.error(this.getClass(), "exitingExpression", "invalid fully qualified name for 'exiting' handler: " + String.valueOf(exitingHandler));
        }
        JCTree.JCExpression exitingHandlerExpression = this.javac.expression(exitingHandler);
        ListBuffer handlerArguments = ListBuffer.lb();
        JCTree.JCExpression thisOrClass = this.helper.methodContext(model);
        handlerArguments.add(thisOrClass);
        JCTree.JCLiteral methodName = this.helper.methodName(model);
        handlerArguments.add(methodName);
        if (model.doesHaveResult()) {
            JCTree.JCExpression methodResult = this.methodResult(model);
            handlerArguments.add(methodResult);
        }
        return this.javac.call(exitingHandlerExpression, handlerArguments.toList());
    }

    protected JCTree.JCExpression methodArguments(Method model) {
        ListBuffer lb = ListBuffer.lb();
        java.util.List<Parameter> parameters = this.filterExcludedParameters(model.getParameters());
        for (Parameter parameter : parameters) {
            JCTree.JCLiteral argumentName = this.javac.literal(parameter.getName());
            JCTree.JCExpression argumentValue = this.argumentExpression(parameter);
            lb.add(argumentName);
            lb.add(argumentValue);
        }
        String argumentsArrayType = this.getArgumentsArrayType();
        if (argumentsArrayType == null || "".equals(argumentsArrayType)) {
            Logger.error(this.getClass(), "methodArguments", "invalid fully qualified name for 'arguments' array type: " + String.valueOf(argumentsArrayType));
        }
        JCTree.JCExpression argumentsArrayTypeExpression = this.javac.expression(argumentsArrayType);
        JCTree.JCNewArray argumentsArray = this.javac.array(argumentsArrayTypeExpression);
        argumentsArray.elems = lb.toList();
        return argumentsArray;
    }

    private java.util.List<Parameter> filterExcludedParameters(java.util.List<Parameter> parameters) {
        ArrayList<Parameter> filteredParameters = new ArrayList<Parameter>();
        for (Parameter parameter : parameters) {
            JCTree.JCVariableDecl representation = (JCTree.JCVariableDecl)parameter.representation();
            if (this.helper.isExcluded(representation)) continue;
            filteredParameters.add(parameter);
        }
        return filteredParameters;
    }

    protected JCTree.JCExpression argumentExpression(Parameter parameter) {
        String argName = parameter.getName();
        return this.javac.expression(argName);
    }

    protected JCTree.JCExpression methodResult(Method model) {
        if (!model.doesHaveResult()) {
            throw new IllegalArgumentException("Provided method model does not have a return value: " + ((JCTree.JCMethodDecl)model.representation()).toString());
        }
        String resultName = this.methodResultVariableName(model);
        return this.javac.identifier(resultName);
    }

    protected String methodResultVariableName(Method model) {
        return "$result_";
    }
}

