/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.collector;

import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.ast.collector.Collector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.model.Parameter;
import java.util.Objects;

public class MethodParameterCollector
extends Collector<Parameter> {
    private final JavaCompiler javac;

    public MethodParameterCollector(JavaCompiler javac, JCTree.JCMethodDecl rootElement) {
        super(rootElement);
        this.javac = Objects.requireNonNull(javac);
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl varDecl) {
        Parameter parameter = this.buildParameterModel(varDecl);
        this.collect(parameter);
        super.visitVarDef(varDecl);
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        this.result = tree;
    }

    protected Parameter buildParameterModel(JCTree.JCVariableDecl param) {
        assert (param.name != null);
        String name = param.name.toString();
        JCTree.JCExpression parameterTypeExpression = param.vartype;
        JCTree.JCExpression jcExpression = this.javac.declarationType(parameterTypeExpression);
        String type = this.javac.fullyQualifiedNameForTypeExpression(jcExpression);
        Parameter parameter = new Parameter(name, type, param);
        Logger.note(this.getClass(), "buildParameterModel", parameter.toString());
        return parameter;
    }
}

