/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.collector;

import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.ast.collector.Collector;
import io.ghostwriter.openjdk.v7.ast.collector.MethodParameterCollector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.model.Clazz;
import io.ghostwriter.openjdk.v7.model.Method;
import io.ghostwriter.openjdk.v7.model.Parameter;
import java.util.List;
import java.util.Objects;

public class MethodDeclarationCollector
extends Collector<Method> {
    private final JavaCompiler javac;

    public MethodDeclarationCollector(JavaCompiler javac, JCTree.JCClassDecl rootClass) {
        super(rootClass);
        this.javac = Objects.requireNonNull(javac);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl klass) {
        this.collectMethodDefinitions(klass);
        super.visitClassDef(klass);
    }

    protected void collectMethodDefinitions(JCTree.JCClassDecl klass) {
        for (JCTree member : klass.getMembers()) {
            if (!(member instanceof JCTree.JCMethodDecl)) continue;
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)member;
            Method method = this.buildMethodModel(klass, methodDecl);
            this.collect(method);
        }
    }

    protected Method buildMethodModel(JCTree.JCClassDecl klass, JCTree.JCMethodDecl methodDeclaration) {
        MethodParameterCollector parameterCollector = new MethodParameterCollector(this.javac, methodDeclaration);
        List<Parameter> parameters = parameterCollector.toList();
        String methodName = this.javac.methodName(methodDeclaration);
        Clazz enclosingClass = new Clazz(klass);
        Method method = new Method(methodName, enclosingClass, parameters, methodDeclaration);
        Logger.note(this.getClass(), "buildMethodModel", method.toString());
        return method;
    }
}

