/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.collector;

import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.ast.collector.Collector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import java.util.Objects;

public class BlockBasedMutatedVariableCollector
extends Collector<JCTree.JCExpression> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;

    public BlockBasedMutatedVariableCollector(JCTree rootElement, JavaCompiler javac, JavaCompilerHelper helper) {
        super(rootElement);
        this.javac = Objects.requireNonNull(javac);
        this.helper = Objects.requireNonNull(helper);
    }

    @Override
    public void visitAssign(JCTree.JCAssign assignment) {
        JCTree.JCExpression variable = assignment.getVariable();
        this.collect(variable);
        super.visitAssign(assignment);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp assignment) {
        JCTree.JCExpression variable = assignment.getVariable();
        this.collect(variable);
        super.visitAssignop(assignment);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        this.result = tree;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl variableDecl) {
        JCTree.JCExpression initializer = variableDecl.getInitializer();
        boolean isDeclarationOnly = initializer == null;
        boolean isExcluded = this.helper.isExcluded(variableDecl);
        if (!isDeclarationOnly && !isExcluded) {
            String variable = variableDecl.getName().toString();
            JCTree.JCExpression variableExpression = this.javac.expression(variable);
            this.collect(variableExpression);
        }
        super.visitVarDef(variableDecl);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jcForLoop) {
        this.result = jcForLoop;
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop forEachLoop) {
        this.result = forEachLoop;
    }

    @Override
    public void visitCatch(JCTree.JCCatch jcCatch) {
        this.result = jcCatch;
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        this.result = tree;
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        boolean isMutableUnaryOperator;
        int operatorCode = tree.getTag();
        boolean bl = isMutableUnaryOperator = operatorCode == 53 || operatorCode == 52 || operatorCode == 55 || operatorCode == 54;
        if (isMutableUnaryOperator) {
            JCTree.JCExpression expression = tree.getExpression();
            this.collect(expression);
        }
        super.visitUnary(tree);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        this.result = tree;
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        this.result = tree;
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        this.result = tree;
    }
}

