/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7;

import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.ast.collector.MethodDeclarationCollector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.compiler.Javac;
import io.ghostwriter.openjdk.v7.ast.translator.MethodTranslator;
import io.ghostwriter.openjdk.v7.common.Instrumenter;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;

public class JavacInstrumenter
implements Instrumenter {
    private Trees trees;
    private JavaCompiler javac;
    private JavaCompilerHelper javacHelper;

    @Override
    public void initialize(ProcessingEnvironment processingEnv) {
        this.trees = Trees.instance(processingEnv);
        this.javac = new Javac(processingEnv);
        this.javacHelper = new JavaCompilerHelper(this.javac);
    }

    @Override
    public void process(Element element) {
        JCTree.JCClassDecl klass = this.toJCClassDecl(element);
        String className = klass.getSimpleName().toString();
        Logger.note(this.getClass(), "process", "instrumenting class: " + className);
        this.processClass(klass);
    }

    protected JCTree.JCClassDecl toJCClassDecl(Element element) {
        JCTree tree = (JCTree)this.trees.getTree(element);
        if (!(tree instanceof JCTree.JCClassDecl)) {
            throw new IllegalArgumentException("Expected type: " + JCTree.JCClassDecl.class.getSimpleName() + ". Got: " + Element.class.getSimpleName());
        }
        JCTree.JCClassDecl klass = (JCTree.JCClassDecl)tree;
        return klass;
    }

    protected void processClass(JCTree.JCClassDecl klass) {
        Logger.note(this.getClass(), "processClass", klass.getSimpleName().toString());
        MethodDeclarationCollector methodCollector = new MethodDeclarationCollector(this.javac, klass);
        this.instrumentMethods(methodCollector.toList());
    }

    protected void instrumentMethods(List<Method> methodModels) {
        MethodTranslator translator = new MethodTranslator(this.javac, this.javacHelper);
        for (Method method : methodModels) {
            translator.translate(method);
        }
    }
}

