/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v8.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.ReturningTranslator;
import io.ghostwriter.openjdk.v8.ast.translator.Lambdas;

public class LambdaAwareReturningTranslator
extends ReturningTranslator {
    private JCTree.JCLambda visitedLambda = null;

    public LambdaAwareReturningTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        super(javac, helper);
    }

    @Override
    public void visitLambda(JCTree.JCLambda jcLambda) {
        if (!Lambdas.doInstrumentLambdas()) {
            this.result = jcLambda;
            return;
        }
        boolean isLambdaBodyWrappedInBlock = jcLambda.body instanceof JCTree.JCBlock;
        if (!isLambdaBodyWrappedInBlock) {
            throw new IllegalStateException("Lambda does not have a body, got: " + jcLambda.body.getClass() + "," + jcLambda.toString());
        }
        this.visitedLambda = jcLambda;
        super.visitLambda(jcLambda);
        this.visitedLambda = null;
    }

    @Override
    protected JCTree.JCLiteral returningExpressionMethodName() {
        if (this.visitedLambda == null) {
            return super.returningExpressionMethodName();
        }
        return this.returningExpressionLambdaName();
    }

    private JCTree.JCLiteral returningExpressionLambdaName() {
        String lambdaName = Lambdas.nameFor(this.getEnclosingMethod(), this.visitedLambda);
        return this.getJavac().literal(lambdaName);
    }
}

