/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.collector.BlockBasedMutatedVariableCollector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Objects;
import java.util.UUID;

public class ReturnExpressionMutationExtractionTranslator
extends TreeTranslator
implements Translator<Method> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;
    private Method model;

    public ReturnExpressionMutationExtractionTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = javac;
        this.helper = helper;
    }

    @Override
    public void translate(Method model) {
        this.model = Objects.requireNonNull(model);
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        representation.accept(this);
    }

    @Override
    public void visitBlock(JCTree.JCBlock block) {
        java.util.List statements = block.getStatements();
        List<JCTree.JCStatement> bodyWithResultCapture = this.createBodyWithResultCapture((List<JCTree.JCStatement>)statements);
        block.stats = bodyWithResultCapture;
        super.visitBlock(block);
    }

    @Override
    public void visitCase(JCTree.JCCase caseStatement) {
        java.util.List statements = caseStatement.getStatements();
        List<JCTree.JCStatement> bodyWithResultCapture = this.createBodyWithResultCapture((List<JCTree.JCStatement>)statements);
        caseStatement.stats = bodyWithResultCapture;
        super.visitCase(caseStatement);
    }

    private List<JCTree.JCStatement> createBodyWithResultCapture(List<JCTree.JCStatement> statements) {
        ListBuffer<JCTree.JCStatement> newBody = new ListBuffer<JCTree.JCStatement>();
        for (JCTree.JCStatement statement : statements) {
            this.processStatement(statement, newBody);
        }
        return newBody.toList();
    }

    private void processStatement(JCTree.JCStatement statement, ListBuffer<JCTree.JCStatement> newBody) {
        boolean isReturnStatement = statement instanceof JCTree.JCReturn;
        if (!isReturnStatement) {
            newBody.add(statement);
            return;
        }
        assert (isReturnStatement);
        JCTree.JCReturn returnStatement = (JCTree.JCReturn)statement;
        this.processReturnStatement(returnStatement, newBody);
    }

    private void processReturnStatement(JCTree.JCReturn returnStatement, ListBuffer<JCTree.JCStatement> newBody) {
        if (this.doesContainMutations(returnStatement)) {
            String generatedCaptureName = this.generateMutationCaptureVariableName();
            JCTree.JCExpression expression = returnStatement.getExpression();
            JCTree.JCVariableDecl mutationResult = this.mutationCaptureVariable(expression, generatedCaptureName);
            returnStatement.expr = this.javac.expression(generatedCaptureName);
            newBody.add(mutationResult);
        }
        newBody.add(returnStatement);
    }

    private boolean doesContainMutations(JCTree.JCReturn returnStatement) {
        java.util.List valueChangeExpressions = new BlockBasedMutatedVariableCollector(returnStatement, this.javac, this.helper).toList();
        return !valueChangeExpressions.isEmpty();
    }

    protected JCTree.JCVariableDecl mutationCaptureVariable(JCTree.JCExpression value, String generatedCaptureName) {
        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)this.model.representation();
        if (!this.helper.hasResult(method)) {
            throw new IllegalArgumentException("Method does not have a return type: " + method.toString());
        }
        JCTree.JCExpression returnType = this.javac.methodReturnType(method);
        JCTree.JCVariableDecl variable = this.javac.finalVariable(returnType, generatedCaptureName, value, method);
        JCTree.JCAnnotation excludeAnnotation = this.javac.annotation("io.ghostwriter.annotation.Exclude");
        variable.mods.annotations = List.of(excludeAnnotation);
        return variable;
    }

    private String generateMutationCaptureVariableName() {
        String uuidPart = UUID.randomUUID().toString().replaceAll("-", "_");
        return "$capturedReturnExpression_" + uuidPart;
    }
}

