/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.ConstructorTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.EnteringExitingTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.OnErrorTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.ReturnExpressionMutationExtractionTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.ReturningTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.TimeoutTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.ast.translator.ValueChangeTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.WrapInBlockTranslator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Objects;

public class MethodTranslator
implements Translator<Method> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;
    private final boolean doTraceValueChanges;
    private final boolean doTraceErrors;
    private final boolean doTraceReturning;
    private final Integer shortMethodLimit;

    public MethodTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = Objects.requireNonNull(javac, "Must provide a valid instance of " + JavaCompiler.class.getSimpleName());
        this.helper = Objects.requireNonNull(helper, "Must provide a valid instance of " + JavaCompilerHelper.class.getSimpleName());
        String envValueChange = javac.getOption("GHOSTWRITER_TRACE_VALUE_CHANGE");
        this.doTraceValueChanges = envValueChange == null ? true : Boolean.parseBoolean(envValueChange);
        Logger.note(this.getClass(), "<init>", "instrument value change tracing: " + this.doTraceValueChanges);
        String envTraceError = javac.getOption("GHOSTWRITER_TRACE_ON_ERROR");
        this.doTraceErrors = envTraceError == null ? true : Boolean.parseBoolean(envTraceError);
        Logger.note(this.getClass(), "<init>", "instrument value error tracing: " + this.doTraceErrors);
        String envReturning = javac.getOption("GHOSTWRITER_TRACE_RETURNING");
        this.doTraceReturning = envReturning == null ? true : Boolean.parseBoolean(envReturning);
        Logger.note(this.getClass(), "<init>", "instrument method returning tracing: " + this.doTraceReturning);
        String envShortMethodLimit = javac.getOption("GHOSTWRITER_SHORT_METHOD_LIMIT");
        this.shortMethodLimit = envShortMethodLimit == null ? null : Integer.valueOf(MethodTranslator.parseIntegerJavacArg(envShortMethodLimit, "GHOSTWRITER_SHORT_METHOD_LIMIT"));
    }

    private static int parseIntegerJavacArg(String argument, String argumentName) {
        try {
            return Integer.parseInt(argument);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Invalid integer is provided for " + argumentName + ". value = " + argument);
        }
    }

    private boolean isShortMethodLimitEnabled() {
        return this.shortMethodLimit != null;
    }

    protected boolean doTraceValueChanges() {
        return this.doTraceValueChanges;
    }

    protected boolean doTraceErrors() {
        return this.doTraceErrors;
    }

    protected boolean doTraceEnteringExiting() {
        return true;
    }

    protected boolean doTraceReturning() {
        return this.doTraceReturning;
    }

    protected boolean doCaptureTimeouts(Method model) {
        JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)model.representation();
        JCTree.JCAnnotation timeoutAnnotation = this.helper.getTimeoutAnnotation(methodDecl);
        return timeoutAnnotation != null;
    }

    @Override
    public void translate(Method model) {
        boolean isDefined;
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        JCTree.JCBlock body = representation.body;
        boolean bl = isDefined = body != null;
        if (!isDefined) {
            return;
        }
        if (this.isShortMethodLimitEnabled() && ((List)body.getStatements()).size() <= this.shortMethodLimit) {
            return;
        }
        this.transformToBlockConstructs(model);
        if (this.doTraceValueChanges()) {
            this.traceValueChanges(model);
        }
        if (this.doTraceEnteringExiting()) {
            this.traceEnteringExiting(model);
        }
        if (this.doTraceReturning()) {
            this.traceReturn(model);
        }
        if (this.doCaptureTimeouts(model)) {
            this.traceTimeout(model);
        }
        if (this.doTraceErrors()) {
            this.traceErrors(model);
        }
        if (this.helper.isConstructor(representation)) {
            this.transformConstructor(model);
        }
        String fullyQualifiedClassName = model.getClazz().getFullyQualifiedClassName();
        Logger.note(this.getClass(), "translate", "(" + fullyQualifiedClassName + ")" + representation.toString());
    }

    protected void traceEnteringExiting(Method model) {
        EnteringExitingTranslator enteringExitingTranslator = new EnteringExitingTranslator(this.javac, this.helper);
        enteringExitingTranslator.translate(model);
    }

    protected void traceReturn(Method model) {
        ReturningTranslator returningTranslator = new ReturningTranslator(this.javac, this.helper);
        returningTranslator.translate(model);
    }

    protected void traceTimeout(Method model) {
        TimeoutTranslator timeoutTranslator = new TimeoutTranslator(this.javac, this.helper);
        timeoutTranslator.translate(model);
    }

    protected void traceErrors(Method model) {
        OnErrorTranslator onErrorTranslator = new OnErrorTranslator(this.javac, this.helper);
        onErrorTranslator.translate(model);
    }

    protected void traceValueChanges(Method model) {
        ReturnExpressionMutationExtractionTranslator returnExpressionTranslator = new ReturnExpressionMutationExtractionTranslator(this.javac, this.helper);
        returnExpressionTranslator.translate(model);
        ValueChangeTranslator valueChangeTranslator = new ValueChangeTranslator(this.javac, this.helper);
        valueChangeTranslator.translate(model);
    }

    protected void transformConstructor(Method model) {
        ConstructorTranslator constructorTranslator = new ConstructorTranslator(this.helper);
        constructorTranslator.translate(model);
    }

    protected void transformToBlockConstructs(Method model) {
        WrapInBlockTranslator wrapInBlockTranslator = new WrapInBlockTranslator(this.javac);
        wrapInBlockTranslator.translate(model);
    }

    protected JavaCompiler getJavac() {
        return this.javac;
    }

    protected JavaCompilerHelper getHelper() {
        return this.helper;
    }
}

