/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.common.RuntimeHandler;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Objects;

public class ReturningTranslator
extends TreeTranslator
implements Translator<Method> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;
    private Method enclosingMethod;

    public ReturningTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = Objects.requireNonNull(javac);
        this.helper = Objects.requireNonNull(helper);
    }

    @Override
    public void translate(Method model) {
        this.setEnclosingMethod(Objects.requireNonNull(model));
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)this.enclosingMethod.representation();
        representation.accept(this);
    }

    @Override
    public void visitBlock(JCTree.JCBlock jcBlock) {
        jcBlock.stats = this.instrumentReturnCapture(jcBlock.stats);
        super.visitBlock(jcBlock);
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        tree.stats = this.instrumentReturnCapture((List<JCTree.JCStatement>)tree.getStatements());
        super.visitCase(tree);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        this.result = tree;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jcClassDecl) {
        this.result = jcClassDecl;
    }

    protected List<JCTree.JCStatement> instrumentReturnCapture(List<JCTree.JCStatement> statements) {
        ListBuffer<JCTree.JCStatement> newBody = new ListBuffer<JCTree.JCStatement>();
        for (JCTree.JCStatement statement : statements) {
            boolean isReturnCall = statement instanceof JCTree.JCReturn;
            if (isReturnCall) {
                JCTree.JCReturn returnStatement = (JCTree.JCReturn)statement;
                this.instrumentReturningCall(newBody, returnStatement);
            }
            newBody.add(statement);
        }
        return newBody.toList();
    }

    protected void instrumentReturningCall(ListBuffer<JCTree.JCStatement> newBody, JCTree.JCReturn returnStatement) {
        boolean isEmptyReturnCall;
        boolean bl = isEmptyReturnCall = returnStatement.getExpression() == null;
        if (isEmptyReturnCall) {
            return;
        }
        JCTree.JCVariableDecl capturedResult = this.captureNestedReturnValue(returnStatement);
        newBody.add(capturedResult);
        JCTree.JCExpressionStatement returningApiCall = this.captureMethodResult(capturedResult.getName().toString());
        newBody.add(returningApiCall);
        this.replaceResultWithCaptureVariable(returnStatement);
    }

    protected void replaceResultWithCaptureVariable(JCTree.JCReturn nestedReturn) {
        String correspondingCapturedResultName = this.resultVariableName(nestedReturn);
        JCTree.JCIdent identifier = this.javac.identifier(correspondingCapturedResultName);
        nestedReturn.expr = identifier;
    }

    protected JCTree.JCVariableDecl captureNestedReturnValue(JCTree.JCReturn returnStatement) {
        String resultVariableName = this.resultVariableName(returnStatement);
        JCTree.JCVariableDecl captureVar = this.javac.finalVariable(this.resultType(), resultVariableName, returnStatement.expr, returnStatement);
        return captureVar;
    }

    protected String resultVariableName(JCTree.JCReturn jcReturn) {
        return "$capturedResult_" + this.enclosingMethod.getName() + "_" + jcReturn.hashCode();
    }

    protected JCTree.JCExpressionStatement captureMethodResult(String resultCaptureVariable) {
        String returningHandler = this.getReturningHandler();
        if (returningHandler == null || "".equals(returningHandler)) {
            Logger.error(this.getClass(), "returningHandler", "invalid fully qualified name for 'exiting' handler: " + String.valueOf(returningHandler));
        }
        JCTree.JCExpression returningHandlerExpression = this.javac.expression(returningHandler);
        ListBuffer<JCTree.JCExpression> handlerArguments = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression thisOrClass = this.returningExpressionContext();
        handlerArguments.add(thisOrClass);
        JCTree.JCLiteral methodName = this.returningExpressionMethodName();
        handlerArguments.add(methodName);
        JCTree.JCExpression returningResult = this.returningResultExpression(this.javac.identifier(resultCaptureVariable));
        handlerArguments.add(returningResult);
        return this.javac.call(returningHandlerExpression, handlerArguments.toList());
    }

    protected JCTree.JCExpression resultType() {
        return (JCTree.JCExpression)((JCTree.JCMethodDecl)this.enclosingMethod.representation()).getReturnType();
    }

    protected JCTree.JCExpression returningResultExpression(JCTree.JCExpression returnExpression) {
        JCTree.JCExpression resultType = this.resultType();
        if (this.javac.isPrimitiveType(resultType)) {
            return this.javac.castToType(resultType, returnExpression);
        }
        return returnExpression;
    }

    protected JCTree.JCExpression returningExpressionContext() {
        return this.helper.methodContext(this.enclosingMethod);
    }

    protected JCTree.JCLiteral returningExpressionMethodName() {
        return this.helper.methodName(this.enclosingMethod);
    }

    protected String getReturningHandler() {
        return RuntimeHandler.RETURNING.toString();
    }

    protected Method getEnclosingMethod() {
        return this.enclosingMethod;
    }

    protected void setEnclosingMethod(Method enclosingMethod) {
        this.enclosingMethod = enclosingMethod;
    }

    protected JavaCompiler getJavac() {
        return this.javac;
    }

    protected JavaCompilerHelper getHelper() {
        return this.helper;
    }
}

