/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7;

import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.ast.collector.MethodDeclarationCollector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.compiler.Javac;
import io.ghostwriter.openjdk.v7.ast.translator.MethodTranslator;
import io.ghostwriter.openjdk.v7.common.Instrumenter;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class Javac7Instrumenter
implements Instrumenter {
    private Trees trees;
    private JavaCompiler javac;
    private JavaCompilerHelper javacHelper;
    private final Set<String> excludedNames = new HashSet<String>();

    @Override
    public void initialize(ProcessingEnvironment processingEnv) {
        this.setTrees(Trees.instance(processingEnv));
        this.setJavac(new Javac(processingEnv));
        this.setJavacHelper(new JavaCompilerHelper(this.javac));
        this.initializeExcludedNames(processingEnv);
    }

    protected void initializeExcludedNames(ProcessingEnvironment processingEnv) {
        String ENV_EXCLUDE_PACKAGES = "GHOSTWRITER_EXCLUDE";
        String excludedNames = processingEnv.getOptions().get("GHOSTWRITER_EXCLUDE");
        if (excludedNames == null) {
            excludedNames = System.getenv("GHOSTWRITER_EXCLUDE");
        }
        if (excludedNames != null) {
            for (String excludedName : excludedNames.split("[\\s,]+")) {
                if (excludedName.endsWith(".*")) {
                    this.excludedNames.add(excludedName.substring(0, excludedName.length() - 2));
                    continue;
                }
                this.excludedNames.add(excludedName);
            }
        }
        Logger.note(this.getClass(), "initializeExcludedNames", "GHOSTWRITER_EXCLUDE initialized to " + this.excludedNames);
    }

    private String getExclusionRule(String qualifiedName) {
        if (this.excludedNames.isEmpty()) {
            return null;
        }
        while (!this.excludedNames.contains(qualifiedName)) {
            int lastDot = qualifiedName.lastIndexOf(46);
            if (lastDot <= 0) {
                return null;
            }
            qualifiedName = qualifiedName.substring(0, lastDot);
        }
        return qualifiedName;
    }

    @Override
    public void process(Element element) {
        String qualifiedName;
        String exclusionRule;
        if (element instanceof TypeElement && (exclusionRule = this.getExclusionRule(qualifiedName = ((TypeElement)element).getQualifiedName().toString())) != null) {
            Logger.note(this.getClass(), "process", "not instrumenting class '" + qualifiedName + "', '" + exclusionRule + "' is excluded");
            return;
        }
        JCTree.JCClassDecl klass = this.toJCClassDecl(element);
        String className = klass.getSimpleName().toString();
        Logger.note(this.getClass(), "process", "instrumenting class: " + className);
        this.processClass(klass);
    }

    protected JCTree.JCClassDecl toJCClassDecl(Element element) {
        JCTree tree = (JCTree)this.trees.getTree(element);
        if (!(tree instanceof JCTree.JCClassDecl)) {
            throw new IllegalArgumentException("Expected type: " + JCTree.JCClassDecl.class.getSimpleName() + ". Got: " + Element.class.getSimpleName());
        }
        JCTree.JCClassDecl klass = (JCTree.JCClassDecl)tree;
        return klass;
    }

    protected void processClass(JCTree.JCClassDecl klass) {
        Logger.note(this.getClass(), "processClass", klass.getSimpleName().toString());
        MethodDeclarationCollector methodCollector = new MethodDeclarationCollector(this.javac, klass);
        this.instrumentMethods(methodCollector.toList());
    }

    protected void instrumentMethods(List<Method> methodModels) {
        MethodTranslator translator = new MethodTranslator(this.javac, this.javacHelper);
        for (Method method : methodModels) {
            translator.translate(method);
        }
    }

    protected JavaCompilerHelper getJavacHelper() {
        return this.javacHelper;
    }

    protected void setJavacHelper(JavaCompilerHelper javacHelper) {
        this.javacHelper = javacHelper;
    }

    protected JavaCompiler getJavac() {
        return this.javac;
    }

    protected void setJavac(JavaCompiler javac) {
        this.javac = javac;
    }

    protected Trees getTrees() {
        return this.trees;
    }

    protected void setTrees(Trees trees) {
        this.trees = trees;
    }
}

