/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v8.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.ValueChangeTranslator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.model.Method;
import io.ghostwriter.openjdk.v8.ast.translator.Lambdas;

public class LambdaAwareValueChangeTranslator
extends ValueChangeTranslator {
    private JCTree.JCLambda visitedLambda;

    public LambdaAwareValueChangeTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        super(javac, helper);
    }

    @Override
    public void visitLambda(JCTree.JCLambda jcLambda) {
        this.visitedLambda = jcLambda;
        super.visitLambda(jcLambda);
        this.visitedLambda = null;
    }

    @Override
    public void visitBlock(JCTree.JCBlock block) {
        if (this.visitedLambda == null || Lambdas.doInstrumentLambdas()) {
            super.visitBlock(block);
            return;
        }
        this.result = block;
    }

    @Override
    protected JCTree.JCExpressionStatement valueChangeExpression(Method model, JCTree.JCExpression variable) {
        if (this.visitedLambda == null) {
            return super.valueChangeExpression(model, variable);
        }
        String valueChangeHandler = this.getValueChangeHandler();
        if (valueChangeHandler == null || "".equals(valueChangeHandler)) {
            Logger.error(this.getClass(), "valueChangeExpression", "invalid fully qualified name for 'valueChange' handler: " + String.valueOf(valueChangeHandler));
        }
        JCTree.JCExpression valueChangeHandlerExpression = this.getJavac().expression(valueChangeHandler);
        ListBuffer<JCTree.JCExpression> handlerArguments = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression thisOrClass = this.getHelper().methodContext(model);
        handlerArguments.add(thisOrClass);
        String lambdaName = Lambdas.nameFor(model, this.visitedLambda);
        JCTree.JCLiteral methodName = this.getJavac().literal(lambdaName);
        handlerArguments.add(methodName);
        JCTree.JCLiteral variableName = this.getJavac().literal(variable.toString());
        handlerArguments.add(variableName);
        handlerArguments.add(variable);
        JCTree.JCExpressionStatement call = this.getJavac().call(valueChangeHandlerExpression, handlerArguments.toList());
        Logger.note(this.getClass(), "valueChangeExpression", call.toString());
        return call;
    }
}

