/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.compiler;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.common.Logger;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeKind;

public class Javac
implements JavaCompiler {
    protected final TreeMaker make;
    protected final JavacElements elements;
    protected final Context context;

    public Javac(ProcessingEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException("Must provide a " + ProcessingEnvironment.class.getSimpleName() + " instance!");
        }
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)env;
        this.context = javacEnv.getContext();
        this.make = TreeMaker.instance(this.context);
        this.elements = JavacElements.instance(this.context);
    }

    @Override
    public String fullyQualifiedNameForTypeExpression(JCTree.JCExpression typeExpression) {
        boolean isAnonymousClass;
        if (typeExpression == null) {
            return Void.class.getName();
        }
        if (this.isPrimitiveType(typeExpression)) {
            JCTree.JCPrimitiveTypeTree primitiveType = (JCTree.JCPrimitiveTypeTree)typeExpression;
            Class<?> wrapper = this.wrapperType(primitiveType);
            return wrapper.getName();
        }
        Type type = typeExpression.type;
        boolean bl = isAnonymousClass = type == null;
        if (isAnonymousClass) {
            return typeExpression.toString();
        }
        boolean isArrayType = type instanceof Type.ArrayType;
        if (isArrayType) {
            return type.getModelType().toString();
        }
        return type.tsym.toString();
    }

    @Override
    public JCTree.JCExpression declarationType(JCTree.JCExpression typeExpression) {
        JCTree.JCExpression declType = typeExpression;
        if (typeExpression == null) {
            declType = this.expression(Void.class.getName());
        }
        return declType;
    }

    @Override
    public boolean isPrimitiveType(JCTree.JCExpression type) {
        return type instanceof JCTree.JCPrimitiveTypeTree;
    }

    @Override
    public Class<?> wrapperType(JCTree.JCPrimitiveTypeTree type) {
        Class wrapper = null;
        TypeKind primitiveTypeKind = type.getPrimitiveTypeKind();
        switch (primitiveTypeKind) {
            case BYTE: {
                wrapper = Byte.class;
                break;
            }
            case CHAR: {
                wrapper = Character.class;
                break;
            }
            case SHORT: {
                wrapper = Short.class;
                break;
            }
            case INT: {
                wrapper = Integer.class;
                break;
            }
            case LONG: {
                wrapper = Long.class;
                break;
            }
            case FLOAT: {
                wrapper = Float.class;
                break;
            }
            case DOUBLE: {
                wrapper = Double.class;
                break;
            }
            case BOOLEAN: {
                wrapper = Boolean.class;
                break;
            }
            case VOID: {
                wrapper = Void.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported primitive type: " + type);
            }
        }
        assert (wrapper != null);
        return wrapper;
    }

    @Override
    public JCTree.JCExpression methodReturnType(JCTree.JCMethodDecl method) {
        JCTree.JCExpression resultTypeExpression = method.restype;
        JCTree.JCExpression resultType = this.declarationType(resultTypeExpression);
        Logger.note(this.getClass(), "methodReturnType", resultType.toString());
        return resultType;
    }

    @Override
    public String methodName(JCTree.JCMethodDecl method) {
        Name name = method.getName();
        String methodName = "";
        if (name != null) {
            methodName = name.toString();
        } else {
            Logger.error(this.getClass(), "methodName", "method does not have a valid name!");
        }
        return methodName;
    }

    @Override
    public JCTree.JCExpression expression(String expr) {
        String[] elements = expr.split("\\.");
        return this.expression(elements);
    }

    protected JCTree.JCExpression expression(String ... elements) {
        JCTree.JCIdent initialExpression;
        if (elements.length < 1) {
            throw new IllegalArgumentException("The expression needs to contain at least one element!");
        }
        boolean INITIAL_PART_OFFSET = false;
        String initialPart = elements[0];
        JCTree.JCExpression expression = initialExpression = this.make.Ident(this.name(initialPart));
        int numberOfFieldAccessParts = elements.length;
        boolean FIELD_ACCESS_PART_OFFSET = true;
        for (int index = 1; index < numberOfFieldAccessParts; ++index) {
            String currentPart = elements[index];
            expression = this.make.Select(expression, this.name(currentPart));
        }
        return expression;
    }

    @Override
    public Name name(String identifierName) {
        return this.elements.getName(identifierName);
    }

    @Override
    public JCTree.JCNewArray array(JCTree.JCExpression type) {
        if (type == null) {
            throw new IllegalArgumentException("Must provide a valid, non 'null' instance of " + JCTree.JCExpression.class.getSimpleName());
        }
        List<JCTree.JCExpression> dimensions = List.nil();
        List<JCTree.JCExpression> values = null;
        JCTree.JCExpression typeExpression = type;
        return this.makeArray(typeExpression, dimensions, values);
    }

    protected JCTree.JCNewArray makeArray(JCTree.JCExpression type, List<JCTree.JCExpression> dimensions, List<JCTree.JCExpression> values) {
        return this.make.NewArray(type, dimensions, values);
    }

    @Override
    public JCTree.JCLiteral literal(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Provided 'value' parameter is null!");
        }
        return this.make.Literal(value);
    }

    @Override
    public JCTree.JCIdent identifier(String name) {
        Name identifierName = this.name(name);
        return this.make.Ident(identifierName);
    }

    @Override
    public JCTree.JCExpressionStatement call(JCTree.JCExpression method, List<JCTree.JCExpression> arguments) {
        JCTree.JCMethodInvocation apply = this.apply(method, arguments);
        JCTree.JCExpressionStatement execute = this.make.Exec(apply);
        return execute;
    }

    @Override
    public JCTree.JCMethodInvocation apply(JCTree.JCExpression method, List<JCTree.JCExpression> arguments) {
        List<JCTree.JCExpression> typeArguments = List.nil();
        return this.make.Apply(typeArguments, method, arguments);
    }

    @Override
    public JCTree.JCVariableDecl finalVariable(JCTree.JCExpression type, String name, JCTree.JCExpression value, JCTree parent) {
        Name variableName = this.name(name);
        JCTree.JCModifiers modifiers = this.make.Modifiers(16L);
        JCTree.JCVariableDecl varDef = this.make.VarDef(modifiers, variableName, type, value);
        varDef.pos = parent.pos;
        return varDef;
    }

    @Override
    public JCTree.JCVariableDecl catchParameter(String name, JCTree parent) {
        JCTree.JCExpression type = this.expression("java.lang.Throwable");
        long flags = 0x200000010L;
        JCTree.JCModifiers modifiers = this.make.Modifiers(0x200000010L);
        Name variableName = this.name(name);
        JCTree.JCVariableDecl jcVariableDecl = this.make.VarDef(modifiers, variableName, type, null);
        jcVariableDecl.pos = parent.pos;
        return jcVariableDecl;
    }

    @Override
    public JCTree.JCAssign assign(JCTree.JCIdent identifier, JCTree.JCExpression expression) {
        JCTree.JCAssign assignExpression = this.make.Assign(identifier, expression);
        return assignExpression;
    }

    @Override
    public JCTree.JCExpressionStatement execute(JCTree.JCExpression expression) {
        JCTree.JCExpressionStatement exec = this.make.Exec(expression);
        return exec;
    }

    @Override
    public JCTree.JCThrow throwStatement(JCTree.JCExpression expr) {
        JCTree.JCThrow throwStatement = this.make.Throw(expr);
        return throwStatement;
    }

    @Override
    public JCTree.JCStatement ifCondition(JCTree.JCExpression condition, JCTree.JCStatement then) {
        JCTree.JCIf ifStatement = this.make.If(condition, then, null);
        return ifStatement;
    }

    @Override
    public JCTree.JCBlock block(List<JCTree.JCStatement> statements) {
        return this.make.Block(0L, statements);
    }

    @Override
    public JCTree.JCTry tryFinally(JCTree.JCBlock tryBlock, JCTree.JCBlock finallyBlock) {
        JCTree.JCTry tryFinally = this.make.Try(tryBlock, List.nil(), finallyBlock);
        return tryFinally;
    }

    @Override
    public JCTree.JCTry tryCatchFinally(JCTree.JCBlock tryBlock, JCTree.JCCatch catchBlock, JCTree.JCBlock finallyBlock) {
        JCTree.JCTry tryFinally = this.make.Try(tryBlock, List.of(catchBlock), finallyBlock);
        return tryFinally;
    }

    @Override
    public JCTree.JCCatch catchExpression(JCTree.JCVariableDecl param, JCTree.JCBlock body) {
        JCTree.JCCatch catchExpr = this.make.Catch(param, body);
        return catchExpr;
    }

    @Override
    public JCTree.JCExpression notEqualExpression(JCTree.JCExpression lhs, JCTree.JCExpression rhs) {
        JCTree.JCBinary binary = this.make.Binary(63, lhs, rhs);
        return binary;
    }

    @Override
    public JCTree.JCExpression defaultValueForType(JCTree.JCExpression type) {
        JCTree.JCExpression defaultValue = this.nullLiteral();
        if (!this.isPrimitiveType(type)) {
            return defaultValue;
        }
        JCTree.JCPrimitiveTypeTree primitiveType = (JCTree.JCPrimitiveTypeTree)type;
        TypeKind primitiveTypeKind = primitiveType.getPrimitiveTypeKind();
        switch (primitiveTypeKind) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                defaultValue = this.literal(0);
                break;
            }
            case LONG: {
                defaultValue = this.literal(0L);
                break;
            }
            case FLOAT: {
                defaultValue = this.literal(Float.valueOf(0.0f));
                break;
            }
            case DOUBLE: {
                defaultValue = this.literal(0.0);
                break;
            }
            case BOOLEAN: {
                defaultValue = this.literal(Boolean.FALSE);
                break;
            }
            case VOID: {
                Logger.error(this.getClass(), "defaultValueForType", "type 'void' does not have a default value!");
                break;
            }
            default: {
                Logger.error(this.getClass(), "defaultValueForType", "unsupported primitive type: " + primitiveType);
            }
        }
        return defaultValue;
    }

    @Override
    public JCTree.JCExpression nullLiteral() {
        JCTree.JCLiteral literal = this.literal("null");
        literal.typetag = (TypeTag)17;
        return literal;
    }

    @Override
    public boolean isStaticMethod(JCTree.JCMethodDecl method) {
        JCTree.JCModifiers modifiers = method.mods;
        return (modifiers.flags & 8L) != 0L;
    }

    @Override
    public JCTree.JCAnnotation annotation(String fullyQualifiedName) {
        JCTree.JCExpression type = this.expression(fullyQualifiedName);
        return this.make.Annotation(type, List.nil());
    }

    @Override
    public JCTree.JCPrimitiveTypeTree primitiveType(String type) {
        int typeKind;
        switch (type) {
            case "byte": {
                typeKind = TypeKind.BYTE.ordinal();
                break;
            }
            case "char": {
                typeKind = TypeKind.CHAR.ordinal();
                break;
            }
            case "short": {
                typeKind = TypeKind.SHORT.ordinal();
                break;
            }
            case "int": {
                typeKind = TypeKind.INT.ordinal();
                break;
            }
            case "long": {
                typeKind = TypeKind.LONG.ordinal();
                break;
            }
            case "float": {
                typeKind = TypeKind.FLOAT.ordinal();
                break;
            }
            case "double": {
                typeKind = TypeKind.DOUBLE.ordinal();
                break;
            }
            case "boolean": {
                typeKind = TypeKind.BOOLEAN.ordinal();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported or unknown primitive type: " + type);
            }
        }
        return this.make.TypeIdent(typeKind + 1);
    }

    @Override
    public JCTree.JCBinary binary(String operation, JCTree.JCExpression lhs, JCTree.JCExpression rhs) {
        int opcode;
        switch (operation) {
            case "<": {
                opcode = 64;
                break;
            }
            case "-": {
                opcode = 72;
                break;
            }
            case "+": {
                opcode = 71;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported binary operator: " + operation);
            }
        }
        return this.make.Binary(opcode, lhs, rhs);
    }

    @Override
    public JCTree.JCReturn makeReturn(JCTree.JCExpression result) {
        return this.make.Return(result);
    }

    @Override
    public JCTree.JCExpression castToType(JCTree returnType, JCTree.JCExpression expression) {
        return this.make.TypeCast(returnType, expression);
    }

    @Override
    public JCTree.JCArrayAccess arrayAccess(JCTree.JCExpression indexed, JCTree.JCExpression index) {
        return this.make.Indexed(indexed, index);
    }
}

