/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.collector;

import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.ast.collector.Collector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import java.util.List;
import java.util.Objects;

public class BlockBasedMutatedVariableCollector
extends Collector<JCTree.JCExpression> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;

    public BlockBasedMutatedVariableCollector(JCTree rootElement, JavaCompiler javac, JavaCompilerHelper helper) {
        super(rootElement);
        this.javac = Objects.requireNonNull(javac);
        this.helper = Objects.requireNonNull(helper);
    }

    @Override
    public void visitAssign(JCTree.JCAssign assignment) {
        super.visitAssign(assignment);
        JCTree.JCExpression assignmentVariable = assignment.getVariable();
        if (this.doesContainMutation(assignmentVariable)) {
            this.collect(this.extractAssignmentTarget(assignmentVariable));
        } else {
            this.collect(assignmentVariable);
        }
    }

    private JCTree.JCExpression extractAssignmentTarget(JCTree.JCExpression assignmentVariable) {
        JCTree.JCExpression sideEffectFreeIndex;
        if (!(assignmentVariable instanceof JCTree.JCArrayAccess)) {
            throw new IllegalArgumentException("Unsupported argument: " + assignmentVariable.getClass().getCanonicalName() + ": " + String.valueOf(assignmentVariable));
        }
        JCTree.JCArrayAccess arrayAccess = (JCTree.JCArrayAccess)assignmentVariable;
        JCTree.JCExpression index = arrayAccess.getIndex();
        boolean isAssignmentOperator = index instanceof JCTree.JCAssignOp;
        if (this.isPostIncrementOperator(index)) {
            JCTree.JCUnary op = (JCTree.JCUnary)index;
            sideEffectFreeIndex = this.javac.binary("-", op.arg, this.javac.literal(1));
        } else if (this.isPostDecrementOperator(index)) {
            JCTree.JCUnary op = (JCTree.JCUnary)index;
            sideEffectFreeIndex = this.javac.binary("+", op.arg, this.javac.literal(1));
        } else if (this.isPreIncrementOperator(index) || this.isPreDecrementOperator(index)) {
            JCTree.JCUnary op = (JCTree.JCUnary)index;
            sideEffectFreeIndex = op.arg;
        } else if (isAssignmentOperator) {
            JCTree.JCAssignOp assignOp = (JCTree.JCAssignOp)index;
            sideEffectFreeIndex = assignOp.getVariable();
        } else {
            throw new IllegalArgumentException("Unsupported expression type " + index.getClass().getCanonicalName() + ": " + String.valueOf(arrayAccess));
        }
        return this.javac.arrayAccess(arrayAccess.indexed, sideEffectFreeIndex);
    }

    private boolean doesContainMutation(JCTree.JCExpression expression) {
        List mutations = new BlockBasedMutatedVariableCollector(expression, this.javac, this.helper).toList();
        return !mutations.isEmpty();
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp assignment) {
        JCTree.JCExpression variable = assignment.getVariable();
        this.collect(variable);
        super.visitAssignop(assignment);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        this.result = tree;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jcClassDecl) {
        this.result = jcClassDecl;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl variableDecl) {
        JCTree.JCExpression initializer = variableDecl.getInitializer();
        boolean isDeclarationOnly = initializer == null;
        boolean isExcluded = this.helper.isExcluded(variableDecl);
        if (!isDeclarationOnly && !isExcluded) {
            String variable = variableDecl.getName().toString();
            JCTree.JCExpression variableExpression = this.javac.expression(variable);
            this.collect(variableExpression);
        }
        super.visitVarDef(variableDecl);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jcForLoop) {
        this.result = jcForLoop;
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop forEachLoop) {
        this.result = forEachLoop;
    }

    @Override
    public void visitCatch(JCTree.JCCatch jcCatch) {
        this.result = jcCatch;
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        this.result = tree;
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        if (this.isMutableUnaryOperator(tree)) {
            JCTree.JCExpression expression = tree.getExpression();
            this.collect(expression);
        }
        super.visitUnary(tree);
    }

    protected boolean isMutableUnaryOperator(JCTree.JCExpression unary) {
        String expression = unary.toString();
        boolean doesContainIncrementOp = expression.contains("++");
        boolean doesContainDecrementOp = expression.contains("--");
        return doesContainDecrementOp || doesContainIncrementOp;
    }

    protected boolean isPostIncrementOperator(JCTree.JCExpression unary) {
        if (!(unary instanceof JCTree.JCUnary)) {
            return false;
        }
        String expression = unary.toString();
        return expression.endsWith("++");
    }

    protected boolean isPostDecrementOperator(JCTree.JCExpression unary) {
        if (!(unary instanceof JCTree.JCUnary)) {
            return false;
        }
        String expression = unary.toString();
        return expression.endsWith("--");
    }

    protected boolean isPreIncrementOperator(JCTree.JCExpression unary) {
        if (!(unary instanceof JCTree.JCUnary)) {
            return false;
        }
        String expression = unary.toString();
        return expression.startsWith("++");
    }

    protected boolean isPreDecrementOperator(JCTree.JCExpression unary) {
        if (!(unary instanceof JCTree.JCUnary)) {
            return false;
        }
        String expression = unary.toString();
        return expression.startsWith("--");
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        this.result = tree;
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        this.result = tree;
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        this.result = tree;
    }
}

