/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.common;

import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;

public final class Logger
extends Enum<Logger> {
    private static Messager messager;
    private static boolean doVerboseLogging;
    private static final /* synthetic */ Logger[] $VALUES;

    public static Logger[] values() {
        return (Logger[])$VALUES.clone();
    }

    public static Logger valueOf(String name) {
        return Enum.valueOf(Logger.class, name);
    }

    private static String format(Class<?> klass, String method, String message) {
        int INITIAL_CAPACITY = 32;
        StringBuilder sb = new StringBuilder(32);
        if (klass != null) {
            sb.append(klass.getName());
            sb.append(".");
        }
        sb.append(method);
        sb.append(": ");
        sb.append(message);
        return sb.toString();
    }

    public static void note(Class<?> type, String method, String message) {
        if (!doVerboseLogging) {
            return;
        }
        Logger.validateState();
        String output = Logger.format(type, method, message);
        messager.printMessage(Diagnostic.Kind.NOTE, output);
    }

    public static void warning(Class<?> type, String method, String message) {
        Logger.validateState();
        String output = Logger.format(type, method, message);
        messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, output);
    }

    public static void error(Class<?> type, String method, String message) {
        Logger.validateState();
        String output = Logger.format(type, method, message);
        messager.printMessage(Diagnostic.Kind.ERROR, output);
    }

    public static void initialize(Messager msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Cannot initialize with null!");
        }
        messager = msg;
    }

    private static void validateState() {
        if (messager == null) {
            throw new IllegalStateException("Logger has not been initialized!");
        }
    }

    static {
        boolean doVerbose;
        $VALUES = new Logger[0];
        doVerboseLogging = false;
        String VERBOSE_LOGGING_ENV = "GHOSTWRITER_VERBOSE";
        String verboseEnv = System.getenv("GHOSTWRITER_VERBOSE");
        doVerboseLogging = doVerbose = Boolean.parseBoolean(verboseEnv);
    }
}

