/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.collector;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import io.ghostwriter.openjdk.v7.common.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Collector<T>
extends TreeTranslator
implements Iterable<T> {
    private final List<T> items = new ArrayList<T>();
    private final JCTree rootElement;
    private boolean hasExecuted = false;

    public Collector(JCTree rootElement) {
        this.rootElement = Objects.requireNonNull(rootElement);
    }

    protected Collector<T> execute() {
        this.rootElement.accept(this);
        return this;
    }

    protected void collect(T item) {
        if (item == null) {
            Logger.warning(this.getClass(), "collect", "tried to collect null item! Skipping!");
            return;
        }
        assert (this.items != null);
        this.items.add(item);
    }

    protected void collectAll(List<T> items) {
        for (T item : items) {
            this.collect(item);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    public List<T> toList() {
        if (!this.hasExecuted) {
            this.execute();
        }
        return Collections.unmodifiableList(this.items);
    }
}

