/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7;

import io.ghostwriter.openjdk.v7.Javac7Instrumenter;
import io.ghostwriter.openjdk.v7.common.Instrumenter;
import io.ghostwriter.openjdk.v7.common.Logger;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class GhostWriterAnnotationProcessor
extends AbstractProcessor {
    protected static boolean NO_ANNOTATIONS_CLAIMED = false;
    private Instrumenter instrumenter;

    public GhostWriterAnnotationProcessor(Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
    }

    public GhostWriterAnnotationProcessor() {
        this(new Javac7Instrumenter());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Logger.initialize(processingEnv.getMessager());
        Logger.note(this.getClass(), "init", "beginning!");
        this.instrumenter.initialize(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return NO_ANNOTATIONS_CLAIMED;
        }
        if (!this.doInstrument()) {
            Logger.note(this.getClass(), "process", "skipping processing...");
            return NO_ANNOTATIONS_CLAIMED;
        }
        Logger.note(this.getClass(), "process", "starting processing...");
        Set<? extends Element> elements = roundEnv.getRootElements();
        for (Element element : elements) {
            ElementKind kind = element.getKind();
            if (kind == null || !kind.isClass()) continue;
            this.instrumenter.process(element);
        }
        return NO_ANNOTATIONS_CLAIMED;
    }

    protected boolean doInstrument() {
        String ENV_INSTRUMENT = "GHOSTWRITER_INSTRUMENT";
        String envInstrument = System.getenv("GHOSTWRITER_INSTRUMENT");
        return envInstrument == null ? true : Boolean.parseBoolean(envInstrument);
    }
}

