/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import io.ghostwriter.openjdk.v7.ast.collector.BlockBasedMutatedVariableCollector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.common.RuntimeHandler;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Iterator;
import java.util.Objects;

public class ValueChangeTranslator
extends TreeTranslator
implements Translator<Method> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;
    private Method processedMethod;

    public ValueChangeTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = javac;
        this.helper = Objects.requireNonNull(helper);
    }

    @Override
    public void translate(Method model) {
        this.processedMethod = Objects.requireNonNull(model);
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)this.processedMethod.representation();
        representation.accept(this);
    }

    @Override
    public void visitBlock(JCTree.JCBlock block) {
        this.captureValueChanges(block);
        super.visitBlock(block);
        this.result = block;
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop forLoop) {
        assert (forLoop.body instanceof JCTree.JCBlock);
        JCTree.JCBlock body = (JCTree.JCBlock)forLoop.body;
        List<JCTree.JCExpression> forLoopVariables = this.collectForLoopUpdateSectionMutatedVariables(forLoop);
        this.captureForLoopVariableChanges(forLoopVariables, body);
        super.visitForLoop(forLoop);
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop forEachLoop) {
        assert (forEachLoop.body instanceof JCTree.JCBlock);
        JCTree.JCBlock body = (JCTree.JCBlock)forEachLoop.body;
        JCTree.JCVariableDecl variable = forEachLoop.getVariable();
        Name name = variable.getName();
        JCTree.JCExpression variableExpression = this.javac.expression(name.toString());
        this.captureForLoopVariableChanges(List.of(variableExpression), body);
        super.visitForeachLoop(forEachLoop);
    }

    private void captureForLoopVariableChanges(List<JCTree.JCExpression> forLoopVariables, JCTree.JCBlock forBlock) {
        for (JCTree.JCExpression variable : forLoopVariables) {
            this.prependValueChangeExpression(variable, forBlock);
        }
    }

    private void prependValueChangeExpression(JCTree.JCExpression variable, JCTree.JCBlock existingBlock) {
        ListBuffer<JCTree.JCExpressionStatement> instrumentedForBody = new ListBuffer<JCTree.JCExpressionStatement>();
        Iterator originalStatements = ((List)existingBlock.getStatements()).iterator();
        JCTree.JCExpressionStatement valueChangeExpression = this.valueChangeExpression(this.processedMethod, variable);
        instrumentedForBody.add(valueChangeExpression);
        while (originalStatements.hasNext()) {
            instrumentedForBody.add((JCTree.JCExpressionStatement)originalStatements.next());
        }
        existingBlock.stats = instrumentedForBody.toList();
    }

    private List<JCTree.JCExpression> collectForLoopUpdateSectionMutatedVariables(JCTree.JCForLoop forLoop) {
        java.util.List updateStatements = forLoop.getUpdate();
        ListBuffer<JCTree.JCExpressionStatement> statements = new ListBuffer<JCTree.JCExpressionStatement>();
        for (JCTree.JCExpressionStatement jcExpressionStatement : updateStatements) {
            statements.add(jcExpressionStatement);
        }
        List<JCTree.JCStatement> jcStatements = statements.toList();
        return this.extractForLoopVariableNames(forLoop, jcStatements);
    }

    private List<JCTree.JCExpression> extractForLoopVariableNames(JCTree.JCForLoop forLoop, List<JCTree.JCStatement> statements) {
        ListBuffer<JCTree.JCExpression> forLoopVariables = new ListBuffer<JCTree.JCExpression>();
        for (JCTree.JCStatement statement : statements) {
            Iterator variables = new BlockBasedMutatedVariableCollector(statement, this.javac, this.helper).iterator();
            if (!variables.hasNext()) {
                throw new IllegalStateException("No variable declaration found for initializer statement: " + forLoop.toString());
            }
            JCTree.JCExpression variable = (JCTree.JCExpression)variables.next();
            if (variables.hasNext()) {
                throw new IllegalStateException("Multiple variable declarations found in initializer statement: " + forLoop.toString());
            }
            forLoopVariables.add(variable);
        }
        return forLoopVariables.toList();
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        this.result = tree;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jcClassDecl) {
        this.result = jcClassDecl;
    }

    private void captureValueChanges(JCTree.JCBlock block) {
        List<JCTree.JCStatement> stats = block.stats;
        block.stats = this.instrumentValueChangeTracing(stats);
    }

    private List<JCTree.JCStatement> instrumentValueChangeTracing(List<JCTree.JCStatement> statements) {
        ListBuffer<JCTree.JCStatement> instrumentedBody = new ListBuffer<JCTree.JCStatement>();
        for (JCTree.JCStatement statement : statements) {
            instrumentedBody.add(statement);
            BlockBasedMutatedVariableCollector valueChangeCollector = new BlockBasedMutatedVariableCollector(statement, this.javac, this.helper);
            for (JCTree.JCExpression variable : valueChangeCollector) {
                this.captureValueChange(instrumentedBody, variable);
            }
        }
        return instrumentedBody.toList();
    }

    private void captureValueChange(ListBuffer<JCTree.JCStatement> instrumentedBody, JCTree.JCExpression variable) {
        JCTree.JCExpressionStatement valueChangeExpression = this.valueChangeExpression(this.processedMethod, variable);
        instrumentedBody.add(valueChangeExpression);
    }

    protected String getValueChangeHandler() {
        return RuntimeHandler.VALUE_CHANGE.toString();
    }

    protected JCTree.JCExpressionStatement valueChangeExpression(Method model, JCTree.JCExpression variable) {
        String valueChangeHandler = this.getValueChangeHandler();
        if (valueChangeHandler == null || "".equals(valueChangeHandler)) {
            Logger.error(this.getClass(), "valueChangeExpression", "invalid fully qualified name for 'valueChange' handler: " + String.valueOf(valueChangeHandler));
        }
        JCTree.JCExpression valueChangeHandlerExpression = this.javac.expression(valueChangeHandler);
        ListBuffer<JCTree.JCExpression> handlerArguments = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression thisOrClass = this.helper.methodContext(model);
        handlerArguments.add(thisOrClass);
        JCTree.JCLiteral methodName = this.helper.methodName(model);
        handlerArguments.add(methodName);
        JCTree.JCLiteral variableName = this.javac.literal(variable.toString());
        handlerArguments.add(variableName);
        handlerArguments.add(variable);
        JCTree.JCExpressionStatement call = this.javac.call(valueChangeHandlerExpression, handlerArguments.toList());
        Logger.note(this.getClass(), "valueChangeExpression", call.toString());
        return call;
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        java.util.List statements = tree.getStatements();
        tree.stats = this.instrumentValueChangeTracing((List<JCTree.JCStatement>)statements);
        super.visitCase(tree);
    }

    @Override
    public void visitTry(JCTree.JCTry tryExpression) {
        java.util.List resources = tryExpression.getResources();
        if (!((List)resources).isEmpty()) {
            this.captureResourceInitializations((List<? extends JCTree>)resources, tryExpression);
        }
        super.visitTry(tryExpression);
    }

    private void captureResourceInitializations(List<? extends JCTree> resources, JCTree.JCTry tryExpression) {
        ListBuffer<JCTree.JCStatement> instrumentedBody = new ListBuffer<JCTree.JCStatement>();
        for (JCTree jCTree : resources) {
            this.captureResourceInitialization(jCTree, instrumentedBody);
        }
        JCTree.JCBlock block = tryExpression.getBlock();
        java.util.List list = block.getStatements();
        for (JCTree.JCStatement statement : list) {
            instrumentedBody.add(statement);
        }
        block.stats = instrumentedBody.toList();
    }

    private void captureResourceInitialization(JCTree resource, ListBuffer<JCTree.JCStatement> instrumentedBody) {
        BlockBasedMutatedVariableCollector resourceMutationCollector = new BlockBasedMutatedVariableCollector(resource, this.javac, this.helper);
        for (JCTree.JCExpression mutation : resourceMutationCollector) {
            this.captureValueChange(instrumentedBody, mutation);
        }
    }

    protected JavaCompiler getJavac() {
        return this.javac;
    }

    protected JavaCompilerHelper getHelper() {
        return this.helper;
    }
}

