/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v8.ast.compiler;

import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import javax.annotation.processing.ProcessingEnvironment;

public class Javac
extends io.ghostwriter.openjdk.v7.ast.compiler.Javac {
    public Javac(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public JCTree.JCExpression nullLiteral() {
        JCTree.JCLiteral literal = this.literal("null");
        literal.typetag = TypeTag.BOT;
        return literal;
    }

    @Override
    public JCTree.JCExpression notEqualExpression(JCTree.JCExpression lhs, JCTree.JCExpression rhs) {
        JCTree.JCBinary binary = this.make.Binary(JCTree.Tag.NE, lhs, rhs);
        return binary;
    }

    @Override
    public JCTree.JCThrow throwStatement(JCTree.JCExpression expr) {
        JCTree.JCThrow throwStatement = this.make.Throw(expr);
        return throwStatement;
    }

    @Override
    public JCTree.JCPrimitiveTypeTree primitiveType(String type) {
        JCTree.JCPrimitiveTypeTree result;
        switch (type) {
            case "int": {
                result = this.make.TypeIdent(TypeTag.INT);
                break;
            }
            case "short": {
                result = this.make.TypeIdent(TypeTag.SHORT);
                break;
            }
            case "byte": {
                result = this.make.TypeIdent(TypeTag.BYTE);
                break;
            }
            case "long": {
                result = this.make.TypeIdent(TypeTag.LONG);
                break;
            }
            case "float": {
                result = this.make.TypeIdent(TypeTag.FLOAT);
                break;
            }
            case "double": {
                result = this.make.TypeIdent(TypeTag.DOUBLE);
                break;
            }
            case "boolean": {
                result = this.make.TypeIdent(TypeTag.BOOLEAN);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported or unknown primitive type: " + type);
            }
        }
        return result;
    }

    @Override
    public JCTree.JCBinary binary(String operation, JCTree.JCExpression lhs, JCTree.JCExpression rhs) {
        JCTree.Tag opcode;
        switch (operation) {
            case "<": {
                opcode = JCTree.Tag.LT;
                break;
            }
            case "-": {
                opcode = JCTree.Tag.MINUS;
                break;
            }
            case "+": {
                opcode = JCTree.Tag.PLUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported binary operator: " + operation);
            }
        }
        return this.make.Binary(opcode, lhs, rhs);
    }
}

