/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.common.RuntimeHandler;
import io.ghostwriter.openjdk.v7.model.Method;
import io.ghostwriter.openjdk.v7.model.Parameter;
import java.util.ArrayList;
import java.util.Objects;

public class EnteringExitingTranslator
extends TreeTranslator
implements Translator<Method> {
    private static final String ARGUMENTS_ARRAY_TYPE = "java.lang.Object";
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;
    private Method method;
    private boolean isProcessingNestedClass;

    public EnteringExitingTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = Objects.requireNonNull(javac);
        this.helper = Objects.requireNonNull(helper);
        this.isProcessingNestedClass = false;
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jcMethodDecl) {
        if (!this.isProcessingNestedClass) {
            java.util.List originalBody = jcMethodDecl.body.getStatements();
            List<JCTree.JCStatement> instrumentedBody = this.instrumentedBody(this.method, (List<JCTree.JCStatement>)originalBody);
            jcMethodDecl.body.stats = instrumentedBody;
        }
        super.visitMethodDef(jcMethodDecl);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jcClassDecl) {
        this.isProcessingNestedClass = true;
        super.visitClassDef(jcClassDecl);
    }

    @Override
    public void translate(Method model) {
        this.method = Objects.requireNonNull(model);
        ((JCTree.JCMethodDecl)model.representation()).accept(this);
    }

    protected List<JCTree.JCStatement> instrumentedBody(Method model, List<JCTree.JCStatement> originalBody) {
        ListBuffer<JCTree.JCStatement> instrumentedBody = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCExpressionStatement enteringExpression = this.enteringExpression(model);
        instrumentedBody.add(enteringExpression);
        JCTree.JCBlock methodBodyBlock = this.javac.block(originalBody);
        JCTree.JCExpressionStatement exitingExpression = this.exitingExpression(model);
        JCTree.JCBlock exitingBlock = this.javac.block(List.of(exitingExpression));
        JCTree.JCTry tryBlock = this.javac.tryFinally(methodBodyBlock, exitingBlock);
        instrumentedBody.add(tryBlock);
        return instrumentedBody.toList();
    }

    protected String getArgumentsArrayType() {
        return ARGUMENTS_ARRAY_TYPE;
    }

    protected String getEnteringHandler() {
        return RuntimeHandler.ENTERING.toString();
    }

    protected String getExitingHandler() {
        return RuntimeHandler.EXITING.toString();
    }

    protected JCTree.JCExpressionStatement enteringExpression(Method model) {
        String enteringHandler = this.getEnteringHandler();
        if (enteringHandler == null || "".equals(enteringHandler)) {
            Logger.error(this.getClass(), "enteringExpression", "invalid fully qualified name for 'entering' handler: " + String.valueOf(enteringHandler));
        }
        JCTree.JCExpression enteringHandlerExpression = this.javac.expression(enteringHandler);
        ListBuffer<JCTree.JCExpression> handlerArguments = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression thisOrClass = this.helper.methodContext(model);
        handlerArguments.add(thisOrClass);
        JCTree.JCLiteral methodName = this.helper.methodName(model);
        handlerArguments.add(methodName);
        JCTree.JCExpression methodArguments = this.enteringHandlerParameterArray(model.getParameters());
        handlerArguments.add(methodArguments);
        return this.javac.call(enteringHandlerExpression, handlerArguments.toList());
    }

    protected JCTree.JCExpressionStatement exitingExpression(Method model) {
        String exitingHandler = this.getExitingHandler();
        if (exitingHandler == null || "".equals(exitingHandler)) {
            Logger.error(this.getClass(), "exitingExpression", "invalid fully qualified name for 'exiting' handler: " + String.valueOf(exitingHandler));
        }
        JCTree.JCExpression exitingHandlerExpression = this.javac.expression(exitingHandler);
        ListBuffer<JCTree.JCExpression> handlerArguments = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression thisOrClass = this.helper.methodContext(model);
        handlerArguments.add(thisOrClass);
        JCTree.JCLiteral methodName = this.helper.methodName(model);
        handlerArguments.add(methodName);
        return this.javac.call(exitingHandlerExpression, handlerArguments.toList());
    }

    protected JCTree.JCExpression enteringHandlerParameterArray(java.util.List<Parameter> parameters) {
        ListBuffer<JCTree.JCExpression> lb = new ListBuffer<JCTree.JCExpression>();
        java.util.List<Parameter> filteredParameters = this.filterExcludedParameters(parameters);
        for (Parameter parameter : filteredParameters) {
            JCTree.JCLiteral argumentName = this.javac.literal(parameter.getName());
            JCTree.JCExpression argumentValue = this.argumentExpression(parameter);
            lb.add(argumentName);
            lb.add(argumentValue);
        }
        String argumentsArrayType = this.getArgumentsArrayType();
        if (argumentsArrayType == null || "".equals(argumentsArrayType)) {
            Logger.error(this.getClass(), "enteringHandlerParameterArray", "invalid fully qualified name for 'arguments' array type: " + String.valueOf(argumentsArrayType));
        }
        JCTree.JCExpression argumentsArrayTypeExpression = this.javac.expression(argumentsArrayType);
        JCTree.JCNewArray argumentsArray = this.javac.array(argumentsArrayTypeExpression);
        argumentsArray.elems = lb.toList();
        return argumentsArray;
    }

    private java.util.List<Parameter> filterExcludedParameters(java.util.List<Parameter> parameters) {
        ArrayList<Parameter> filteredParameters = new ArrayList<Parameter>();
        for (Parameter parameter : parameters) {
            JCTree.JCVariableDecl representation = (JCTree.JCVariableDecl)parameter.representation();
            if (this.helper.isExcluded(representation)) continue;
            filteredParameters.add(parameter);
        }
        return filteredParameters;
    }

    protected JCTree.JCExpression argumentExpression(Parameter parameter) {
        String argName = parameter.getName();
        return this.javac.expression(argName);
    }

    protected Method getMethod() {
        return this.method;
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    protected JavaCompiler getJavac() {
        return this.javac;
    }

    protected JavaCompilerHelper getJavacHelper() {
        return this.helper;
    }
}

