/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v8.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.collector.ParameterCollector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.EnteringExitingTranslator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.model.Method;
import io.ghostwriter.openjdk.v7.model.Parameter;
import io.ghostwriter.openjdk.v8.ast.translator.Lambdas;

public class LambdaAwareEnteringExitingTranslator
extends EnteringExitingTranslator {
    private JCTree.JCLambda visitedLambda = null;

    public LambdaAwareEnteringExitingTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        super(javac, helper);
    }

    @Override
    public void visitLambda(JCTree.JCLambda jcLambda) {
        boolean isLambdaBodyWrappedInBlock = jcLambda.body instanceof JCTree.JCBlock;
        if (!isLambdaBodyWrappedInBlock) {
            throw new IllegalStateException("Lambda does not have a body, got: " + jcLambda.body.getClass() + "," + jcLambda.toString());
        }
        this.visitedLambda = jcLambda;
        JCTree.JCBlock bodyBlock = (JCTree.JCBlock)jcLambda.body;
        java.util.List originalBody = bodyBlock.getStatements();
        Method enclosingMethod = this.getMethod();
        List<JCTree.JCStatement> instrumentedBody = this.instrumentedBody(enclosingMethod, (List<JCTree.JCStatement>)originalBody);
        bodyBlock.stats = instrumentedBody;
        this.visitedLambda = null;
        super.visitLambda(jcLambda);
    }

    @Override
    protected JCTree.JCExpressionStatement enteringExpression(Method model) {
        if (this.visitedLambda == null) {
            return super.enteringExpression(model);
        }
        return this.enteringLambdaExpression(model, this.visitedLambda);
    }

    @Override
    protected JCTree.JCExpressionStatement exitingExpression(Method model) {
        if (this.visitedLambda == null) {
            return super.exitingExpression(model);
        }
        return this.exitingLambdaExpression(model, this.visitedLambda);
    }

    private JCTree.JCExpressionStatement exitingLambdaExpression(Method model, JCTree.JCLambda visitedLambda) {
        String exitingHandler = this.getExitingHandler();
        if (exitingHandler == null || "".equals(exitingHandler)) {
            Logger.error(this.getClass(), "exitingLambdaExpression", "invalid fully qualified name for 'exiting' handler: " + String.valueOf(exitingHandler));
        }
        JCTree.JCExpression exitingHandlerExpression = this.getJavac().expression(exitingHandler);
        ListBuffer<JCTree.JCExpression> handlerArguments = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression thisOrClass = this.getJavacHelper().methodContext(model);
        handlerArguments.add(thisOrClass);
        String lambdaName = Lambdas.nameFor(model, visitedLambda);
        JCTree.JCLiteral methodName = this.getJavac().literal(lambdaName);
        handlerArguments.add(methodName);
        return this.getJavac().call(exitingHandlerExpression, handlerArguments.toList());
    }

    protected JCTree.JCExpressionStatement enteringLambdaExpression(Method model, JCTree.JCLambda visitedLambda) {
        String enteringHandler = this.getEnteringHandler();
        if (enteringHandler == null || "".equals(enteringHandler)) {
            Logger.error(this.getClass(), "enteringLambdaExpression", "invalid fully qualified name for 'entering' handler: " + String.valueOf(enteringHandler));
        }
        JCTree.JCExpression enteringHandlerExpression = this.getJavac().expression(enteringHandler);
        ListBuffer<JCTree.JCExpression> handlerArguments = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression thisOrClass = this.getJavacHelper().methodContext(model);
        handlerArguments.add(thisOrClass);
        String lambdaName = Lambdas.nameFor(model, visitedLambda);
        JCTree.JCLiteral methodName = this.getJavac().literal(lambdaName);
        handlerArguments.add(methodName);
        java.util.List<Parameter> lambdaParameters = new ParameterCollector(this.getJavac(), visitedLambda).toList();
        JCTree.JCExpression methodArguments = this.enteringHandlerParameterArray(lambdaParameters);
        handlerArguments.add(methodArguments);
        return this.getJavac().call(enteringHandlerExpression, handlerArguments.toList());
    }
}

