/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.compiler;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Objects;

public class JavaCompilerHelper {
    private static final String EXCLUDE_ANNOTATION_TYPE = "io.ghostwriter.annotation.Exclude";
    private static final String TIMEOUT_ANNOTATION_TYPE = "io.ghostwriter.annotation.Timeout";
    private final JavaCompiler javac;

    public JavaCompilerHelper(JavaCompiler javac) {
        this.javac = Objects.requireNonNull(javac);
    }

    public JCTree.JCLiteral methodName(Method model) {
        String name = model.getName();
        return this.javac.literal(name);
    }

    public JCTree.JCExpression methodContext(Method model) {
        JCTree.JCExpression context = this.javac.identifier("this");
        boolean isStaticMethod = this.javac.isStaticMethod((JCTree.JCMethodDecl)model.representation());
        if (isStaticMethod) {
            String fullyQualifiedClassName = model.getClazz().getFullyQualifiedClassName();
            String staticClassContext = fullyQualifiedClassName + ".class";
            context = this.javac.expression(staticClassContext);
        }
        return context;
    }

    public boolean isConstructor(JCTree.JCMethodDecl methodDecl) {
        String CONSTRUCTOR_IDENTIFIER = "<init>";
        String methodName = this.javac.methodName(methodDecl);
        return "<init>".equals(methodName);
    }

    public boolean hasResult(JCTree.JCMethodDecl methodDecl) {
        JCTree.JCExpression type = methodDecl.restype;
        boolean result = false;
        if (type != null) {
            String typeName = type.toString();
            result = !"void".equals(typeName) && !"java.lang.Void".equals(typeName);
        }
        return result;
    }

    public boolean isStatementSuperOrThisCall(JCTree.JCStatement statement) {
        String THIS = "this(";
        String SUPER = "super(";
        String expressionStatement = statement.toString();
        boolean result = false;
        boolean isThisCall = expressionStatement.startsWith("this(");
        boolean isSuperCall = expressionStatement.startsWith("super(");
        if (isThisCall || isSuperCall) {
            result = true;
        }
        return result;
    }

    private static JCTree.JCAnnotation getExcludeAnnotation(JCTree.JCClassDecl classDecl) {
        List<JCTree.JCAnnotation> annotations = classDecl.mods.annotations;
        return JavaCompilerHelper.findFirstAnnotation(annotations, EXCLUDE_ANNOTATION_TYPE);
    }

    public boolean isExcluded(JCTree.JCClassDecl classDecl) {
        return JavaCompilerHelper.getExcludeAnnotation(classDecl) != null;
    }

    private static JCTree.JCAnnotation getExcludeAnnotation(JCTree.JCMethodDecl methodDecl) {
        List<JCTree.JCAnnotation> annotations = methodDecl.mods.annotations;
        return JavaCompilerHelper.findFirstAnnotation(annotations, EXCLUDE_ANNOTATION_TYPE);
    }

    public boolean isExcluded(JCTree.JCMethodDecl methodDecl) {
        return JavaCompilerHelper.getExcludeAnnotation(methodDecl) != null;
    }

    private static JCTree.JCAnnotation getExcludeAnnotation(JCTree.JCVariableDecl variableDecl) {
        List<JCTree.JCAnnotation> annotations = variableDecl.mods.annotations;
        return JavaCompilerHelper.findFirstAnnotation(annotations, EXCLUDE_ANNOTATION_TYPE);
    }

    public boolean isExcluded(JCTree.JCVariableDecl variableDecl) {
        return JavaCompilerHelper.getExcludeAnnotation(variableDecl) != null;
    }

    public JCTree.JCAnnotation getTimeoutAnnotation(JCTree.JCMethodDecl methodDecl) {
        List<JCTree.JCAnnotation> annotations = methodDecl.mods.annotations;
        return JavaCompilerHelper.findFirstAnnotation(annotations, TIMEOUT_ANNOTATION_TYPE);
    }

    private static JCTree.JCAnnotation findFirstAnnotation(List<JCTree.JCAnnotation> annotations, String targetAnnotationType) {
        if (targetAnnotationType != null && targetAnnotationType.isEmpty()) {
            throw new IllegalArgumentException("Specified annotation type is not valid: " + targetAnnotationType);
        }
        JCTree.JCAnnotation resultAnnotation = null;
        for (JCTree.JCAnnotation annotation : annotations) {
            String expectedAnnotationType;
            String actualAnnotationType;
            boolean isAnnotatedLocalVariable;
            boolean bl = isAnnotatedLocalVariable = annotation.type == null;
            if (!isAnnotatedLocalVariable) {
                String annotationFullyQualifiedName;
                actualAnnotationType = annotationFullyQualifiedName = annotation.type.toString();
                expectedAnnotationType = targetAnnotationType;
            } else {
                String annotationType = annotation.getAnnotationType().toString();
                actualAnnotationType = JavaCompilerHelper.simpleNameOfAnnotation(annotationType);
                expectedAnnotationType = JavaCompilerHelper.simpleNameOfAnnotation(targetAnnotationType);
            }
            if (!actualAnnotationType.equals(expectedAnnotationType)) continue;
            resultAnnotation = annotation;
            break;
        }
        return resultAnnotation;
    }

    private static String simpleNameOfAnnotation(String fullyQualifiedTypeOfAnnotation) {
        String[] tokens = fullyQualifiedTypeOfAnnotation.split("[.]");
        String result = fullyQualifiedTypeOfAnnotation;
        if (tokens.length > 0) {
            result = tokens[tokens.length - 1];
        }
        return result;
    }
}

