/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.model;

import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.model.AstModel;
import java.util.Objects;

public class Parameter
extends AstModel<JCTree.JCVariableDecl> {
    private final String name;
    private final String type;

    public Parameter(String name, String type, JCTree.JCVariableDecl representation) {
        super(representation);
        Objects.requireNonNull(name, "Must provide a valid parameter name!");
        Objects.requireNonNull(type, "Must provide a valid parameter type!");
        if ("".equals(name)) {
            throw new IllegalArgumentException("Must provide a non-empty parameter name!");
        }
        if ("".equals(type)) {
            throw new IllegalArgumentException("Must provide a non-empty, fully qualified name of the parameter type!");
        }
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "Parameter [name=" + this.name + ", type=" + this.type + "]";
    }
}

