/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.model.Method;

public class WrapInBlockTranslator
extends TreeTranslator
implements Translator<Method> {
    protected final JavaCompiler javac;

    public WrapInBlockTranslator(JavaCompiler javac) {
        this.javac = javac;
    }

    @Override
    public void translate(Method model) {
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        representation.accept(this);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop forLoop) {
        forLoop.body = this.wrappedBody(forLoop.body);
        super.visitForLoop(forLoop);
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop forEachLoop) {
        forEachLoop.body = this.wrappedBody(forEachLoop.body);
        super.visitForeachLoop(forEachLoop);
    }

    @Override
    public void visitIf(JCTree.JCIf ifStatement) {
        ifStatement.thenpart = this.wrappedBody(ifStatement.getThenStatement());
        JCTree.JCStatement elseStatement = ifStatement.getElseStatement();
        if (elseStatement != null) {
            ifStatement.elsepart = this.wrappedBody(elseStatement);
        }
        super.visitIf(ifStatement);
    }

    protected JCTree.JCBlock wrappedBody(JCTree.JCStatement statement) {
        boolean isBlock = statement instanceof JCTree.JCBlock;
        if (isBlock) {
            return (JCTree.JCBlock)statement;
        }
        return this.javac.block(List.of(statement));
    }
}

