/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.collector.ConstructorCallCollector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Objects;

public class ConstructorTranslator
extends TreeTranslator
implements Translator<Method> {
    private JCTree.JCExpressionStatement constructorCall;
    private final JavaCompilerHelper helper;

    public ConstructorTranslator(JavaCompilerHelper helper) {
        this.helper = Objects.requireNonNull(helper);
    }

    @Override
    public void translate(Method model) {
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        if (!this.helper.isConstructor(representation)) {
            throw new IllegalArgumentException("Provided method is not a constructor: " + representation.toString());
        }
        this.constructorCall = this.getConstructorCall(model);
        if (this.constructorCall != null) {
            representation.accept(this);
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jcMethodDecl) {
        super.visitMethodDef(jcMethodDecl);
        jcMethodDecl.body.stats = this.prependToMethodBody(jcMethodDecl.body, this.constructorCall);
    }

    private JCTree.JCExpressionStatement getConstructorCall(Method model) {
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)model.representation();
        ConstructorCallCollector constructorCalls = new ConstructorCallCollector(this.helper, representation);
        java.util.List jcExpressionStatements = constructorCalls.toList();
        boolean EXPECTED_NUMBER_OF_CONSTRUCTOR_CALLS = true;
        int numCalls = jcExpressionStatements.size();
        JCTree.JCExpressionStatement result = null;
        if (numCalls == 1) {
            result = (JCTree.JCExpressionStatement)jcExpressionStatements.get(0);
        }
        if (numCalls > 1) {
            throw new IllegalStateException("Method contains '" + numCalls + "' constructor calls! Method: " + representation);
        }
        return result;
    }

    private List<JCTree.JCStatement> prependToMethodBody(JCTree.JCBlock body, JCTree.JCExpressionStatement superOrThisCall) {
        List<JCTree.JCStatement> statements = body.stats;
        return statements.prepend(superOrThisCall);
    }

    @Override
    public void visitBlock(JCTree.JCBlock block) {
        List<JCTree.JCStatement> statements = this.removeConstructorCallsFromBlock(block);
        super.visitBlock(block);
        block.stats = statements;
        this.result = block;
    }

    private List<JCTree.JCStatement> removeConstructorCallsFromBlock(JCTree.JCBlock block) {
        ListBuffer<JCTree.JCStatement> sanitizedStatements = new ListBuffer<JCTree.JCStatement>();
        for (JCTree.JCStatement statement : block.getStatements()) {
            if (this.helper.isStatementSuperOrThisCall(statement)) continue;
            sanitizedStatements.add(statement);
        }
        return sanitizedStatements.toList();
    }
}

