/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7;

import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import io.ghostwriter.openjdk.v7.ast.collector.MethodDeclarationCollector;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.compiler.Javac;
import io.ghostwriter.openjdk.v7.ast.translator.MethodTranslator;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.common.Instrumenter;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class Javac7Instrumenter
implements Instrumenter {
    private Trees trees;
    private JavaCompiler javac;
    private JavaCompilerHelper javacHelper;
    private boolean isAnnotatedOnlyMode;
    private final Set<String> excludedClasses = new HashSet<String>();
    private final Set<String> excludedMethodNames = new HashSet<String>();
    private static final List<String> DEFAULT_EXCLUDED_METHODS = Collections.unmodifiableList(Arrays.asList("toString", "equals", "hashCode", "compareTo"));

    @Override
    public void initialize(ProcessingEnvironment processingEnv) {
        this.setTrees(Trees.instance(processingEnv));
        this.setJavac(new Javac(processingEnv));
        this.setJavacHelper(new JavaCompilerHelper(this.javac));
        Logger.initialize(processingEnv.getMessager(), Boolean.parseBoolean(this.javac.getOption("GHOSTWRITER_VERBOSE")));
        Logger.note(this.getClass(), "init", "beginning!");
        this.initializeFromEnv(processingEnv);
    }

    protected void initializeFromEnv(ProcessingEnvironment processingEnv) {
        this.initializeExcludedClasses(processingEnv);
        this.initializeExcludedMethodNames(processingEnv);
        this.initializeAnnotationOnlyMode(processingEnv);
    }

    protected final void initializeExcludedClasses(ProcessingEnvironment processingEnv) {
        String rawExcludedNames = this.javac.getOption("GHOSTWRITER_EXCLUDE");
        if (rawExcludedNames != null) {
            for (String excludedName : rawExcludedNames.split("[\\s,]+")) {
                if (excludedName.endsWith(".*")) {
                    this.excludedClasses.add(excludedName.substring(0, excludedName.length() - 2));
                    continue;
                }
                this.excludedClasses.add(excludedName);
            }
        }
        Logger.note(this.getClass(), "initializeExcludedNames", "GHOSTWRITER_EXCLUDE initialized to " + this.excludedClasses);
    }

    protected final void initializeExcludedMethodNames(ProcessingEnvironment processingEnv) {
        String rawExcludedMethodNames = this.javac.getOption("GHOSTWRITER_EXCLUDE_METHODS");
        if (rawExcludedMethodNames != null) {
            String[] names = rawExcludedMethodNames.split("[\\s,]+");
            this.excludedMethodNames.addAll(Arrays.asList(names));
            Logger.note(this.getClass(), "initializeExcludedMethodNames", "custom exclude methods: " + this.excludedMethodNames);
        } else {
            this.excludedMethodNames.addAll(DEFAULT_EXCLUDED_METHODS);
            Logger.note(this.getClass(), "initializeExcludedMethodNames", "default exclude methods: " + this.excludedMethodNames);
        }
    }

    protected final void initializeAnnotationOnlyMode(ProcessingEnvironment processingEnv) {
        String rawEnvAnnotatedOnly = this.javac.getOption("GHOSTWRITER_ANNOTATED_ONLY");
        this.isAnnotatedOnlyMode = rawEnvAnnotatedOnly != null && Boolean.parseBoolean(rawEnvAnnotatedOnly);
        Logger.note(this.getClass(), "initializeAnnotationOnlyMode", "annotated only mode enabled: " + this.isAnnotatedOnlyMode);
    }

    private String getExclusionRule(String qualifiedName) {
        if (this.excludedClasses.isEmpty()) {
            return null;
        }
        while (!this.excludedClasses.contains(qualifiedName)) {
            int lastDot = qualifiedName.lastIndexOf(46);
            if (lastDot <= 0) {
                return null;
            }
            qualifiedName = qualifiedName.substring(0, lastDot);
        }
        return qualifiedName;
    }

    @Override
    public void process(Element element) {
        String qualifiedName;
        String exclusionRule;
        if (element instanceof TypeElement && (exclusionRule = this.getExclusionRule(qualifiedName = ((TypeElement)element).getQualifiedName().toString())) != null) {
            Logger.note(this.getClass(), "process", "not instrumenting class '" + qualifiedName + "', '" + exclusionRule + "' is excluded");
            return;
        }
        JCTree.JCClassDecl klass = this.toJCClassDecl(element);
        String className = klass.getSimpleName().toString();
        Logger.note(this.getClass(), "process", "instrumenting class: " + className);
        this.processClass(klass);
    }

    @Override
    public boolean doInstrument() {
        String doInstrument = this.javac.getOption("GHOSTWRITER_INSTRUMENT");
        return doInstrument == null ? true : Boolean.parseBoolean(doInstrument);
    }

    protected JCTree.JCClassDecl toJCClassDecl(Element element) {
        JCTree tree = (JCTree)this.trees.getTree(element);
        if (!(tree instanceof JCTree.JCClassDecl)) {
            throw new IllegalArgumentException("Expected type: " + JCTree.JCClassDecl.class.getSimpleName() + ". Got: " + Element.class.getSimpleName());
        }
        JCTree.JCClassDecl klass = (JCTree.JCClassDecl)tree;
        return klass;
    }

    protected void processClass(JCTree.JCClassDecl klass) {
        Logger.note(this.getClass(), "processClass", klass.getSimpleName().toString());
        MethodDeclarationCollector methodCollector = new MethodDeclarationCollector(this.javac, klass);
        this.instrumentMethods(methodCollector.toList());
    }

    protected void instrumentMethods(List<Method> methodModels) {
        Translator<Method> translator = this.getMethodTranslator();
        for (Method method : methodModels) {
            if (this.isMethodExcluded(method)) continue;
            translator.translate(method);
        }
    }

    protected final boolean isMethodExcluded(Method method) {
        if (this.isMethodExcludedByEnv(method)) {
            Logger.note(this.getClass(), "isMethodExcluded", "skipping instrumentation of method (env): " + method.getName());
            return true;
        }
        if (this.isMethodExcludedByAnnotation(method)) {
            Logger.note(this.getClass(), "isMethodExcluded", "skipping instrumentation of method (annotation): " + method.getName());
            return true;
        }
        if (this.isAnnotatedOnlyMode() && !this.isIncludedClassOrMethod(method)) {
            Logger.note(this.getClass(), "isMethodExcluded", "skipping un-annotated method: " + method.getName());
            return true;
        }
        return false;
    }

    protected final boolean isMethodExcludedByEnv(Method model) {
        return this.excludedMethodNames.contains(model.getName());
    }

    protected final boolean isMethodExcludedByAnnotation(Method model) {
        JCTree.JCMethodDecl methodRepresentation = (JCTree.JCMethodDecl)model.representation();
        boolean isMethodExcluded = this.javacHelper.isExcluded(methodRepresentation);
        JCTree.JCClassDecl classRepresentation = (JCTree.JCClassDecl)model.getClazz().representation();
        boolean isClassExcluded = this.javacHelper.isExcluded(classRepresentation);
        return isClassExcluded || isMethodExcluded;
    }

    protected final boolean isIncludedClassOrMethod(Method model) {
        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)model.representation();
        JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)model.getClazz().representation();
        return this.javacHelper.isIncluded(clazz) || this.javacHelper.isIncluded(method);
    }

    protected final boolean isAnnotatedOnlyMode() {
        return this.isAnnotatedOnlyMode;
    }

    protected JavaCompilerHelper getJavacHelper() {
        return this.javacHelper;
    }

    protected void setJavacHelper(JavaCompilerHelper javacHelper) {
        this.javacHelper = javacHelper;
    }

    protected JavaCompiler getJavac() {
        return this.javac;
    }

    protected void setJavac(JavaCompiler javac) {
        this.javac = javac;
    }

    protected Trees getTrees() {
        return this.trees;
    }

    protected void setTrees(Trees trees) {
        this.trees = trees;
    }

    protected Translator<Method> getMethodTranslator() {
        return new MethodTranslator(this.javac, this.javacHelper);
    }
}

