/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7;

import io.ghostwriter.openjdk.v7.Javac7Instrumenter;
import io.ghostwriter.openjdk.v7.common.Instrumenter;
import io.ghostwriter.openjdk.v7.common.Logger;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedOptions(value={"GHOSTWRITER_ANNOTATED_ONLY", "GHOSTWRITER_EXCLUDE", "GHOSTWRITER_TRACE_ON_ERROR", "GHOSTWRITER_TRACE_RETURNING", "GHOSTWRITER_TRACE_VALUE_CHANGE", "GHOSTWRITER_EXCLUDE_METHODS", "GHOSTWRITER_INSTRUMENT", "GHOSTWRITER_VERBOSE", "GHOSTWRITER_SHORT_METHOD_LIMIT"})
public class GhostWriterAnnotationProcessor
extends AbstractProcessor {
    protected static boolean NO_ANNOTATIONS_CLAIMED = false;
    private Instrumenter instrumenter;

    public GhostWriterAnnotationProcessor(Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
    }

    public GhostWriterAnnotationProcessor() {
        this(new Javac7Instrumenter());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.instrumenter.initialize(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return NO_ANNOTATIONS_CLAIMED;
        }
        if (!this.instrumenter.doInstrument()) {
            Logger.note(this.getClass(), "process", "skipping processing...");
            return NO_ANNOTATIONS_CLAIMED;
        }
        Logger.note(this.getClass(), "process", "starting processing...");
        Set<? extends Element> elements = roundEnv.getRootElements();
        for (Element element : elements) {
            ElementKind kind = element.getKind();
            if (kind == null || !kind.isClass()) continue;
            this.instrumenter.process(element);
        }
        return NO_ANNOTATIONS_CLAIMED;
    }
}

