/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.common.RuntimeHandler;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Iterator;
import java.util.Objects;

public class TimeoutTranslator
implements Translator<Method> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;

    public TimeoutTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = Objects.requireNonNull(javac);
        this.helper = Objects.requireNonNull(helper);
    }

    @Override
    public void translate(Method model) {
        long timeoutThreshold = this.getTimeoutThreshold(model);
        this.instrumentStartMeasurement(model);
        this.instrumentStopMeasurement(model, timeoutThreshold);
    }

    private void instrumentStartMeasurement(Method model) {
        String startTimestampVariableName = this.getStartTimestampVariableName(model);
        JCTree.JCVariableDecl startTimestamp = this.captureTimeStamp(startTimestampVariableName, model);
        ListBuffer<JCTree.JCStatement> newBody = new ListBuffer<JCTree.JCStatement>();
        newBody.add(startTimestamp);
        JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)model.representation();
        this.appendStatements(newBody, methodDecl.body);
        methodDecl.body.stats = newBody.toList();
    }

    private void instrumentStopMeasurement(Method model, long timeoutThreshold) {
        ListBuffer<JCTree.JCStatement> newBody = new ListBuffer<JCTree.JCStatement>();
        String stopTimestampVariableName = this.getStopTimestampVariableName(model);
        JCTree.JCVariableDecl stopTimestamp = this.captureTimeStamp(stopTimestampVariableName, model);
        newBody.add(stopTimestamp);
        JCTree.JCStatement deltaCheck = this.timestampDeltaCheck(model, timeoutThreshold);
        newBody.add(deltaCheck);
        JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)model.representation();
        JCTree.JCTry enteringExitingTryConstruct = this.findEnteringExitingTryConstruct(methodDecl);
        JCTree.JCBlock finallyBlock = enteringExitingTryConstruct.getFinallyBlock();
        this.appendStatements(newBody, finallyBlock);
        enteringExitingTryConstruct.finalizer.stats = newBody.toList();
    }

    private JCTree.JCStatement timestampDeltaCheck(Method model, long timeoutThreshold) {
        String startTimestampVariableName = this.getStartTimestampVariableName(model);
        String stopTimestampVariableName = this.getStopTimestampVariableName(model);
        JCTree.JCIdent stopIdentifier = this.javac.identifier(stopTimestampVariableName);
        JCTree.JCIdent startIdentifier = this.javac.identifier(startTimestampVariableName);
        JCTree.JCBinary measurementDelta = this.javac.binary("-", stopIdentifier, startIdentifier);
        JCTree.JCBinary deltaCondition = this.javac.binary("<", this.javac.literal(timeoutThreshold), measurementDelta);
        JCTree.JCStatement deltaCheck = this.javac.ifCondition(deltaCondition, this.timeoutHandlerBlock(model, timeoutThreshold, measurementDelta));
        return deltaCheck;
    }

    private JCTree.JCBlock timeoutHandlerBlock(Method model, long timeoutThreshold, JCTree.JCBinary measurementDelta) {
        String timeoutHandler = this.getTimeoutHandler();
        if (timeoutHandler == null || "".equals(timeoutHandler)) {
            Logger.error(this.getClass(), "timeoutHandlerBlock", "invalid fully qualified name for 'timeout' handler: " + String.valueOf(timeoutHandler));
        }
        JCTree.JCExpression enteringHandlerExpression = this.javac.expression(timeoutHandler);
        ListBuffer<JCTree.JCExpression> handlerArguments = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression thisOrClass = this.helper.methodContext(model);
        handlerArguments.add(thisOrClass);
        JCTree.JCLiteral methodName = this.helper.methodName(model);
        handlerArguments.add(methodName);
        handlerArguments.add(this.javac.literal(timeoutThreshold));
        handlerArguments.add(measurementDelta);
        JCTree.JCExpressionStatement call = this.javac.call(enteringHandlerExpression, handlerArguments.toList());
        return this.javac.block(List.of(call));
    }

    private String getStartTimestampVariableName(Method model) {
        return "_$startTimestamp_" + model.getName();
    }

    private String getStopTimestampVariableName(Method model) {
        return "_$stopTimestamp_" + model.getName();
    }

    private JCTree.JCVariableDecl captureTimeStamp(String timestampVariableName, Method model) {
        JCTree.JCExpression method = this.javac.expression("System.currentTimeMillis");
        JCTree.JCMethodInvocation callCurrentTimeMillis = this.javac.apply(method, List.nil());
        JCTree.JCPrimitiveTypeTree longType = this.javac.primitiveType("long");
        return this.javac.finalVariable(longType, timestampVariableName, callCurrentTimeMillis, (JCTree)model.representation());
    }

    private void appendStatements(ListBuffer<JCTree.JCStatement> newBody, JCTree.JCBlock originalBody) {
        List<JCTree.JCStatement> statements = originalBody.stats;
        for (JCTree.JCStatement statement : statements) {
            newBody.add(statement);
        }
    }

    private JCTree.JCTry findEnteringExitingTryConstruct(JCTree.JCMethodDecl representation) {
        Iterator<JCTree.JCStatement> statements = representation.body.stats.iterator();
        JCTree.JCTry result = null;
        while (statements.hasNext()) {
            JCTree.JCStatement currentStatement = statements.next();
            if (!(currentStatement instanceof JCTree.JCTry)) continue;
            result = (JCTree.JCTry)currentStatement;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Missing the entering/exiting block for the method:  " + representation.toString());
        }
        return result;
    }

    private long getTimeoutThreshold(Method model) {
        JCTree.JCAnnotation timeoutAnnotation = this.helper.getTimeoutAnnotation((JCTree.JCMethodDecl)model.representation());
        java.util.List arguments = timeoutAnnotation.getArguments();
        if (((List)arguments).isEmpty()) {
            throw new IllegalStateException("Missing threshold value from Timeout annotation: " + String.valueOf(timeoutAnnotation));
        }
        boolean NUMBER_OF_TIMEOUT_ANNOTATION_ATTRIBUTES = true;
        if (((List)arguments).size() != 1) {
            throw new IllegalStateException("Unexpected number of annotation attributes on: " + String.valueOf(timeoutAnnotation));
        }
        JCTree.JCAssign thresholdExpression = (JCTree.JCAssign)((List)arguments).get(0);
        String valueLiteral = thresholdExpression.rhs.toString();
        return Long.parseLong(valueLiteral);
    }

    public String getTimeoutHandler() {
        return RuntimeHandler.TIMEOUT.toString();
    }
}

