/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.openjdk.v7.ast.translator;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.ListBuffer;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompiler;
import io.ghostwriter.openjdk.v7.ast.compiler.JavaCompilerHelper;
import io.ghostwriter.openjdk.v7.ast.translator.Translator;
import io.ghostwriter.openjdk.v7.common.Logger;
import io.ghostwriter.openjdk.v7.common.RuntimeHandler;
import io.ghostwriter.openjdk.v7.model.Method;
import java.util.Objects;

public class ReturningTranslator
extends TreeTranslator
implements Translator<Method> {
    private final JavaCompiler javac;
    private final JavaCompilerHelper helper;
    private Method enclosingMethod;

    public ReturningTranslator(JavaCompiler javac, JavaCompilerHelper helper) {
        this.javac = Objects.requireNonNull(javac);
        this.helper = Objects.requireNonNull(helper);
    }

    @Override
    public void translate(Method model) {
        this.enclosingMethod = Objects.requireNonNull(model);
        JCTree.JCMethodDecl representation = (JCTree.JCMethodDecl)this.enclosingMethod.representation();
        representation.accept(this);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        this.result = tree;
    }

    @Override
    public void visitReturn(JCTree.JCReturn jcReturn) {
        boolean isEmptyReturnStatement;
        JCTree.JCExpression expression = jcReturn.getExpression();
        boolean bl = isEmptyReturnStatement = expression == null;
        if (!isEmptyReturnStatement) {
            JCTree.JCExpression returningExpression;
            jcReturn.expr = returningExpression = this.instrumentReturningExpression(expression);
        }
        super.visitReturn(jcReturn);
    }

    protected JCTree.JCExpression instrumentReturningExpression(JCTree.JCExpression returnExpression) {
        String returningHandler = this.getReturningHandler();
        if (returningHandler == null || "".equals(returningHandler)) {
            Logger.error(this.getClass(), "returningHandler", "invalid fully qualified name for 'exiting' handler: " + String.valueOf(returningHandler));
        }
        JCTree.JCExpression returningHandlerExpression = this.javac.expression(returningHandler);
        ListBuffer<JCTree.JCExpression> handlerArguments = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression thisOrClass = this.returningExpressionContext();
        handlerArguments.add(thisOrClass);
        JCTree.JCLiteral methodName = this.returningExpressionMethodName();
        handlerArguments.add(methodName);
        JCTree.JCExpression returningResult = this.returningResultExpression(returnExpression);
        handlerArguments.add(returningResult);
        JCTree.JCExpression resultType = this.resultType();
        JCTree.JCMethodInvocation returningCall = this.javac.apply(returningHandlerExpression, handlerArguments.toList());
        JCTree.JCExpression typeCoercedGwCall = this.javac.castToType(resultType, returningCall);
        return typeCoercedGwCall;
    }

    protected JCTree.JCExpression resultType() {
        return (JCTree.JCExpression)((JCTree.JCMethodDecl)this.enclosingMethod.representation()).getReturnType();
    }

    protected JCTree.JCExpression returningResultExpression(JCTree.JCExpression returnExpression) {
        JCTree.JCExpression resultType = this.resultType();
        if (this.javac.isPrimitiveType(resultType)) {
            return this.javac.castToType(resultType, returnExpression);
        }
        return returnExpression;
    }

    protected JCTree.JCExpression returningExpressionContext() {
        return this.helper.methodContext(this.enclosingMethod);
    }

    protected JCTree.JCLiteral returningExpressionMethodName() {
        return this.helper.methodName(this.enclosingMethod);
    }

    protected String getReturningHandler() {
        return RuntimeHandler.RETURNING.toString();
    }

    protected Method getEnclosingMethod() {
        return this.enclosingMethod;
    }

    protected void setEnclosingMethod(Method enclosingMethod) {
        this.enclosingMethod = enclosingMethod;
    }

    protected JavaCompiler getJavac() {
        return this.javac;
    }

    protected JavaCompilerHelper getHelper() {
        return this.helper;
    }
}

