/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter;

import io.ghostwriter.NoopTracerProvider;
import io.ghostwriter.Tracer;
import io.ghostwriter.TracerProvider;
import java.util.ServiceLoader;

public enum GhostWriter {
    INSTANCE;

    private TracerProvider<? extends Tracer> tracerProvider = this.initialize();

    public static void setTracerProvider(TracerProvider<? extends Tracer> tp) {
        if (tp == null) {
            throw new NullPointerException("Must provide a valid instance!");
        }
        Tracer tracer = tp.getTracer();
        GhostWriter.INSTANCE.tracerProvider = tp;
        System.out.println("GWRT: Initialized with Tracer implementation: " + tracer.getClass().getCanonicalName());
    }

    public static void entering(Object source, String method, Object ... params) {
        Tracer tracer = GhostWriter.INSTANCE.tracerProvider.getTracer();
        tracer.entering(source, method, params);
    }

    public static void exiting(Object source, String method, Object retVal) {
        Tracer tracer = GhostWriter.INSTANCE.tracerProvider.getTracer();
        tracer.exiting(source, method, retVal);
    }

    public static void exiting(Object source, String method) {
        Tracer tracer = GhostWriter.INSTANCE.tracerProvider.getTracer();
        tracer.exiting(source, method);
    }

    public static void valueChange(Object source, String method, String variable, Object value) {
        Tracer tracer = GhostWriter.INSTANCE.tracerProvider.getTracer();
        tracer.valueChange(source, method, variable, value);
    }

    public static void onError(Object source, String method, Throwable error) {
        Tracer tracer = GhostWriter.INSTANCE.tracerProvider.getTracer();
        tracer.onError(source, method, error);
    }

    private TracerProvider<?> initialize() {
        TracerProvider foundProv = null;
        ServiceLoader<TracerProvider> serviceLoader = ServiceLoader.load(TracerProvider.class);
        for (TracerProvider tracerProvider : serviceLoader) {
            Object tracer = tracerProvider.getTracer();
            if (foundProv == null && !(tracerProvider instanceof NoopTracerProvider) && tracer != null) {
                foundProv = tracerProvider;
                System.out.println("GWRT: Initialized with Tracer implementation: " + tracer.getClass().getCanonicalName());
                continue;
            }
            if (tracer == null) continue;
            System.out.println("GWRT: Found other tracer implementation: " + tracer.getClass().getCanonicalName());
        }
        if (foundProv != null) {
            return foundProv;
        }
        System.out.println("GWRT: Using the default no-op implementation!");
        return new NoopTracerProvider();
    }
}

