/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.web.utils;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class WebRequestUtils {
    public static boolean isIE(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return false;
        }
        return (userAgent = userAgent.toLowerCase()).indexOf("msie") > 0 || userAgent.indexOf("rv:11.0") > 0 || userAgent.indexOf("edge") > 0;
    }

    public static Map<String, String> getCookies(HttpServletRequest request, String ... names) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Cookie[] cookies = request.getCookies();
        HashMap<String, String> result = new HashMap<String, String>();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                for (String name : names) {
                    if (!name.equals(cookie.getName()) || StringUtils.isEmpty((Object)cookie.getValue())) continue;
                    result.put(name, cookie.getValue());
                }
            }
        }
        return result;
    }

    public static Map<String, Enumeration<String>> getHeaders(HttpServletRequest request, String ... names) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        HashMap<String, Enumeration<String>> result = new HashMap<String, Enumeration<String>>();
        for (String name : names) {
            Enumeration headers = request.getHeaders(name);
            result.put(name, headers);
        }
        return result;
    }
}

