/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.web.convert.converter;

import io.geewit.core.utils.enums.EnumUtils;
import io.geewit.core.utils.enums.Value;
import java.io.Serializable;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;

public class EnumValueConverter<S extends Serializable, T extends Enum<T>>
implements Converter<S, T>,
ConditionalConverter {
    private TypeDescriptor targetType;

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (!(sourceType.isAssignableTo(TypeDescriptor.valueOf(String.class)) || sourceType.isAssignableTo(TypeDescriptor.valueOf(Integer.TYPE)) || sourceType.isAssignableTo(TypeDescriptor.valueOf(Integer.class)))) {
            return false;
        }
        if (targetType.isAssignableTo(TypeDescriptor.valueOf(Enum.class)) && targetType.isAssignableTo(TypeDescriptor.valueOf(Value.class))) {
            this.targetType = targetType;
            return true;
        }
        return false;
    }

    public T convert(S source) {
        if (source instanceof Integer) {
            try {
                return (T)EnumUtils.forToken((Class)this.targetType.getObjectType(), (Integer)((Integer)source));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (source instanceof String) {
            try {
                int value = Integer.parseInt((String)source);
                return (T)EnumUtils.forToken((Class)this.targetType.getObjectType(), (Integer)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

