/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.oltu.oidc.client.response;

import io.geewit.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import io.geewit.oltu.oauth2.common.exception.OAuthProblemException;
import io.geewit.oltu.oauth2.jwt.JWT;
import io.geewit.oltu.oauth2.jwt.io.JWTReader;
import java.util.Objects;

public class OpenIdConnectResponse
extends OAuthJSONAccessTokenResponse {
    private JWT idToken;

    protected void init(String body, String contentType, int responseCode) throws OAuthProblemException {
        super.init(body, contentType, responseCode);
        try {
            this.idToken = (JWT)new JWTReader().read(this.getParam("id_token"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public final JWT getIdToken() {
        return this.idToken;
    }

    public boolean checkId(String issuer, String audience) {
        return Objects.equals(this.idToken.getClaimsSet().getIssuer(), issuer) && Objects.equals(this.idToken.getClaimsSet().getAudience(), audience) && this.idToken.getClaimsSet().getExpirationTime() < System.currentTimeMillis();
    }
}

