/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oidc.client.response;

import java.util.Objects;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.jwt.JWT;
import org.apache.oltu.oauth2.jwt.io.JWTReader;

public class OpenIdConnectResponse
extends OAuthJSONAccessTokenResponse {
    private JWT idToken;

    protected void init(String body, String contentType, int responseCode) throws OAuthProblemException {
        super.init(body, contentType, responseCode);
        try {
            this.idToken = (JWT)new JWTReader().read(this.getParam("id_token"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public final JWT getIdToken() {
        return this.idToken;
    }

    public boolean checkId(String issuer, String audience) {
        return Objects.equals(this.idToken.getClaimsSet().getIssuer(), issuer) && Objects.equals(this.idToken.getClaimsSet().getAudience(), audience) && this.idToken.getClaimsSet().getExpirationTime() < System.currentTimeMillis();
    }
}

